/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.remote.PersBioTemplateRemote;
import com.zkteco.zkbiosecurity.pers.service.PersBioTemplateService;
import com.zkteco.zkbiosecurity.pers.util.ItemUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersBioTemplateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class PersBioTemplateController
extends ExportController
implements PersBioTemplateRemote {
    @Autowired
    private PersBioTemplateService persBioTemplateService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"pers:bioTemplate:import"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_import_biologicalTemplate", requestParams={}, opContent="pers_import_biologicalTemplate")
    public ZKResultMsg importExcel(MultipartFile upload) {
        HashMap convertMap = new HashMap();
        HashMap<String, String> bioTypeMap = new HashMap<String, String>();
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_universal", (Object[])new Object[0]), "0");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_regFinger", (Object[])new Object[0]), "1");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_infraredFace", (Object[])new Object[0]), "2");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_voice", (Object[])new Object[0]), "3");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_iris", (Object[])new Object[0]), "4");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_retina", (Object[])new Object[0]), "5");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_palmPrints", (Object[])new Object[0]), "6");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_regVein", (Object[])new Object[0]), "7");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_metacarpalVein", (Object[])new Object[0]), "8");
        bioTypeMap.put(I18nUtil.i18nCode((String)"pers_person_visibleFace", (Object[])new Object[0]), "9");
        convertMap.put("bioTypeVal", bioTypeMap);
        HashMap<String, String> validTypeMap = new HashMap<String, String>();
        validTypeMap.put(I18nUtil.i18nCode((String)"pers_card_disabled", (Object[])new Object[0]), "0");
        validTypeMap.put(I18nUtil.i18nCode((String)"pers_card_effect", (Object[])new Object[0]), "1");
        convertMap.put("validType", validTypeMap);
        HashMap<String, String> duressMap = new HashMap<String, String>();
        duressMap.put(I18nUtil.i18nCode((String)"common_yes", (Object[])new Object[0]), "true");
        duressMap.put(I18nUtil.i18nCode((String)"common_no", (Object[])new Object[0]), "false");
        convertMap.put("duress", duressMap);
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), PersBioTemplateItem.class, convertMap);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            ZKResultMsg res = this.persBioTemplateService.importData(itemList);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)res);
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Bio Template Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"pers:bioTemplate:export"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_export_personBioTemplate", opContent="pers_export_personBioTemplate")
    public void export() {
        PersBioTemplateItem bioTemplateItem = new PersBioTemplateItem();
        this.setConditionValue((BaseItem)bioTemplateItem);
        List intemList = this.persBioTemplateService.getItemData(bioTemplateItem, this.request.getSession().getId(), this.getBeginIndex(), this.getEndIndex());
        HashMap map = new HashMap();
        HashMap<String, String> jsonColumn = new HashMap<String, String>();
        jsonColumn.put("jsonColumn", ItemUtil.itemFiledToJsonColumn((BaseItem)bioTemplateItem));
        map.put("jsonColumn", jsonColumn);
        this.excelExport(intemList, PersBioTemplateItem.class, map);
    }
}

