/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersAttributeRemote;
import com.zkteco.zkbiosecurity.pers.service.PersAttributeService;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersAttributeController
extends BaseController
implements PersAttributeRemote {
    @Autowired
    private PersAttributeService persAttributeService;

    @RequiresPermissions(value={"pers:attribute"})
    public ModelAndView index() {
        return new ModelAndView("pers/attribute/persAttribute");
    }

    @RequiresPermissions(value={"pers:attribute:edit", "pers:attribute:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        PersAttributeItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.persAttributeService.getItemById(id);
            String attrName = I18nUtil.i18nCode((String)("pers_attr_" + item.getAttrName()), (Object[])new Object[0]);
            if (!attrName.contains("pers_attr_")) {
                item.setAttrName(attrName);
            }
            this.request.setAttribute("item", (Object)item);
        }
        this.request.setAttribute("maxLimit", (Object)false);
        if (item == null) {
            List attrList = this.persAttributeService.getByCondition(new PersAttributeItem());
            if (attrList.size() >= 32) {
                this.request.setAttribute("maxLimit", (Object)true);
            }
            Integer defaultX = 1;
            Integer defaultY = 1;
            Integer defFiledIndex = 1;
            Set filedIndexs = attrList.stream().map(PersAttributeItem::getFiledIndex).collect(Collectors.toSet());
            int i2 = 1;
            while (i2 <= 32) {
                if (filedIndexs.add(i2)) {
                    defFiledIndex = i2;
                    break;
                }
                ++i2;
            }
            Set rowSet = attrList.stream().map(i -> i.getPositionX() + "_" + i.getPositionY()).collect(Collectors.toSet());
            int i3 = 6;
            while (i3 < 40) {
                defaultX = i3 / 2;
                defaultY = i3 % 2 + 1;
                if (rowSet.add(defaultX + "_" + defaultY)) break;
                ++i3;
            }
            this.request.setAttribute("defaultX", (Object)defaultX);
            this.request.setAttribute("defaultY", (Object)defaultY);
            this.request.setAttribute("defFiledIndex", (Object)defFiledIndex);
        }
        return new ModelAndView("pers/attribute/editPersAttribute");
    }

    @RequiresPermissions(value={"pers:attribute:edit", "pers:attribute:add"})
    @LogRequest(module="pers_module", object="pers_attribute", opType="common_op_edit", requestParams={"attrName"}, opContent="pers_attribute_attrName")
    public ZKResultMsg save(PersAttributeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.persAttributeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:attribute:refresh"})
    public DxGrid list(PersAttributeItem condition) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAttrName()})) {
            List attrList = this.persAttributeService.getItemsByInit();
            List idList = this.persAttributeService.findIdsByAttrName(condition.getAttrName());
            for (PersAttributeItem initAttr : attrList) {
                String attrName = I18nUtil.i18nCode((String)("pers_attr_" + initAttr.getAttrName()), (Object[])new Object[0]);
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{attrName}) || !attrName.toLowerCase().contains(condition.getAttrName().toLowerCase())) continue;
                idList.add(initAttr.getId());
            }
            if (!idList.isEmpty()) {
                condition.setAttrName(null);
                condition.setInId(StringUtils.join((Iterable)idList, (String)","));
            }
        }
        Pager pager = this.persAttributeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="pers_module", object="pers_attribute", opType="common_op_del", requestParams={"attrName"}, opContent="pers_attribute_attrName")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.persAttributeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExist(@RequestParam(value="id") String id, @RequestParam(value="showName") String showName) {
        boolean isExist = false;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{showName})) {
            isExist = true;
            List attrList = this.persAttributeService.getByCondition(new PersAttributeItem());
            for (PersAttributeItem attr : attrList) {
                String attrName;
                String attributeName = "";
                attributeName = "init".equals(attr.getSqlStr()) ? (StringUtils.isNotBlank((CharSequence)(attrName = I18nUtil.i18nCode((String)("pers_attr_" + attr.getAttrName()), (Object[])new Object[0]))) && !attrName.contains("pers_attr_") ? attrName : attr.getAttrName()) : attr.getAttrName();
                if (!showName.equals(attributeName) || attr.getId().toString().equals(id)) continue;
                isExist = false;
                break;
            }
        } else {
            PersAttributeItem item = new PersAttributeItem();
            item.setAttrName(showName);
            isExist = this.persAttributeService.getByCondition(item).isEmpty();
        }
        return String.valueOf(isExist);
    }

    public String isRowColExist(@RequestParam(value="id") String id, @RequestParam(value="positionX") Integer positionX, @RequestParam(value="positionY") Integer positionY) {
        boolean flag = true;
        PersAttributeItem condition = new PersAttributeItem();
        condition.setPositionX(positionX);
        condition.setPositionY(positionY);
        List items = this.persAttributeService.getByCondition(condition);
        for (PersAttributeItem item : items) {
            if (item.getId().equals(id)) continue;
            flag = false;
            break;
        }
        return String.valueOf(flag);
    }

    public ZKResultMsg getAllPersAttrs() {
        List items = this.persAttributeService.getByCondition(new PersAttributeItem());
        HashMap map = Maps.newHashMap();
        for (PersAttributeItem item : items) {
            String name;
            String attrName = item.getAttrName();
            if ("init".equals(item.getSqlStr()) && StringUtils.isNotBlank((CharSequence)(name = I18nUtil.i18nCode((String)("pers_attr_" + attrName), (Object[])new Object[0]))) && !name.contains("pers_attr_")) {
                attrName = name;
            }
            map.put(item.getFiledIndex(), attrName);
        }
        return new ZKResultMsg((Object)map);
    }

    public String countAttrList() {
        boolean maxLimit = false;
        List attrList = this.persAttributeService.getByCondition(new PersAttributeItem());
        if (attrList.size() >= 32) {
            maxLimit = true;
        }
        return String.valueOf(maxLimit);
    }
}

