/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.AppPersonItem;
import com.zkteco.zkbiosecurity.pers.api.vo.AppUserPicItem;
import com.zkteco.zkbiosecurity.pers.service.PersAppBioService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.util.PersCheckUtil;
import com.zkteco.zkbiosecurity.pers.util.ValidatorsUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/token/register"})
public class PersAppRegisterController
extends BaseController {
    @Autowired
    private PersAppBioService persAppBioService;
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersPersonService persPersonService;

    @RequestMapping(value={"/saveUser"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg register(@RequestBody AppPersonItem appPersonItem) {
        PersCheckUtil.checkAppPerson(appPersonItem, null);
        if (StringUtils.isBlank((CharSequence)appPersonItem.getPassword())) {
            throw ZKBusinessException.errorException((String)"base_userService_setUser09", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.persAppBioService.savePersonRegister(appPersonItem));
    }

    @RequestMapping(value={"/saveUserPic"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg saveUserPic(@RequestBody AppUserPicItem item) {
        if (StringUtils.isBlank((CharSequence)item.getMobile())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_person_mobilePhoneValidate", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)item.getPhotoBase64())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_h5_personAvatarNotNull", (Object[])new Object[0]));
        }
        String photoBase64 = item.getPhotoBase64().replaceAll("[\\s*\t\n\r]", "");
        if (!ValidatorsUtils.isImage(photoBase64)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_api_selectPhotoInvalid", (Object[])new Object[0]));
        }
        if (ValidatorsUtils.isOverSize(photoBase64)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_h5_imgSizeError", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.persAppBioService.savePersonPic(item.getMobile(), photoBase64));
    }

    @RequestMapping(value={"/getPersPin"}, method={RequestMethod.GET})
    @ResponseBody
    public ZKResultMsg getPersPin() {
        ZKResultMsg result = ZKResultMsg.successMsg();
        Map paramMap = this.persParamsService.getPersParams();
        if (!paramMap.isEmpty()) {
            String pin;
            String pinSupportLetter = (String)paramMap.get("pers.pinSupportLetter");
            String pinSupportIncrement = (String)paramMap.get("pers.pinSupportIncrement");
            if ("false".equals(pinSupportLetter) && "true".equals(pinSupportIncrement) && StringUtils.isNotEmpty((CharSequence)(pin = this.persPersonService.getIncPoint()))) {
                JSONObject pinObject = new JSONObject();
                pinObject.put("pin", (Object)pin);
                result.setData((Object)pinObject);
            }
        }
        return result;
    }

    @RequestMapping(path={"/getPersParams"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getPersParams() {
        return this.persAppBioService.getPersParams();
    }

    @RequestMapping(value={"/sendEmail"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg sendEmail(@RequestBody AppPersonItem appPersonItem) {
        String pin = appPersonItem.getPin();
        String email = appPersonItem.getEmail();
        if (StringUtils.isBlank((CharSequence)pin) || StringUtils.isBlank((CharSequence)email)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_h5_pinOrEmailIsNull", (Object[])new Object[0]));
        }
        return this.persAppBioService.sendEmailForResetPassword(pin, email, this.request.getHeader("Host"));
    }
}

