/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.pers.app.vo.PersAppParamsItem;
import com.zkteco.zkbiosecurity.pers.app.vo.PersAppPersonItem;
import com.zkteco.zkbiosecurity.pers.service.PersAppService;
import com.zkteco.zkbiosecurity.pers.service.PersCardService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersCardItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/v1"})
public class PersAppController {
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersAppService persAppService;
    @Autowired
    private PersCardService persCardService;

    @RequestMapping(value={"/getPersPin"}, method={RequestMethod.POST})
    public AppResultMessage getPersPin() {
        AppResultMessage appResultMessage = AppResultMessage.successMessage();
        Map paramMap = this.persParamsService.getPersParams();
        if (!paramMap.isEmpty()) {
            String pin;
            String pinSupportLetter = (String)paramMap.get("pers.pinSupportLetter");
            String pinSupportIncrement = (String)paramMap.get("pers.pinSupportIncrement");
            String pinLen = (String)paramMap.get("pers.pinLen");
            if ("false".equals(pinSupportLetter) && "true".equals(pinSupportIncrement) && StringUtils.isNotEmpty((CharSequence)(pin = this.persPersonService.getIncPoint()))) {
                JSONObject pinObject = new JSONObject();
                pinObject.put("pin", (Object)pin);
                appResultMessage.setData((Object)pinObject);
            }
        }
        return appResultMessage;
    }

    @RequestMapping(value={"/editPersPerson"}, method={RequestMethod.POST})
    public AppResultMessage editPersPerson(@RequestBody PersAppPersonItem personBean) {
        return this.persAppService.editAppPerson(personBean);
    }

    @RequestMapping(value={"/getDepts"}, method={RequestMethod.POST})
    public AppResultMessage getDepts(@RequestBody JSONObject data) {
        String token = data.getString("token");
        return this.persAppService.getDepts(token);
    }

    @RequestMapping(value={"/getPersonDataCount"}, method={RequestMethod.POST})
    @ResponseBody
    public AppResultMessage getPersonDataCount() {
        return this.persAppService.getPersonDataCount();
    }

    @RequestMapping(value={"/getPersonByPinOrName"}, method={RequestMethod.POST})
    public AppResultMessage getPersonByPinOrName(@RequestBody JSONObject data) {
        String filter = data.getString("filter");
        String token = data.getString("token");
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        return this.persAppService.getPersonByPinOrName(filter, token, pageNo, pageSize);
    }

    @RequestMapping(value={"/getPersonByPin"}, method={RequestMethod.POST})
    public AppResultMessage getPersonByPin(@RequestBody PersAppPersonItem persAppPersonItem) {
        String pin = persAppPersonItem.getPin();
        if (StringUtils.isBlank((CharSequence)pin)) {
            return AppResultMessage.failMessage().setRet(String.valueOf(-20));
        }
        return this.persAppService.getPersonByPin(pin, persAppPersonItem.getToken());
    }

    @RequestMapping(value={"/getAccLevelsByPin"}, method={RequestMethod.POST})
    public AppResultMessage getAccLevelsByPin(@RequestBody PersAppPersonItem persAppPersonItem) {
        String pin = persAppPersonItem.getPin();
        return this.persAppService.getAccLevelsByPin(pin, persAppPersonItem.getToken());
    }

    @RequestMapping(value={"/delRealById"}, method={RequestMethod.POST})
    public AppResultMessage delRealByPin(@RequestBody PersAppPersonItem persAppPersonItem) {
        String pin = persAppPersonItem.getPin();
        if (StringUtils.isBlank((CharSequence)pin)) {
            return AppResultMessage.failMessage().setRet(String.valueOf(-20));
        }
        PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
        if (persPersonItem == null) {
            return AppResultMessage.failMessage().setRet(String.valueOf(-22));
        }
        this.persPersonService.deleteByIds(persPersonItem.getId());
        return AppResultMessage.successMessage();
    }

    @RequestMapping(value={"/getParams"}, method={RequestMethod.POST})
    public String getParams() {
        JSONObject params = new JSONObject();
        Map persParams = this.persParamsService.getPersParams();
        params.put("pinLen", persParams.get("pers.pinLen"));
        params.put("pinSupportLetter", persParams.get("pers.pinSupportLetter"));
        params.put("pinSupportDefault", persParams.get("pers.pinSupportDefault"));
        params.put("pinSupportIncrement", persParams.get("pers.pinSupportIncrement"));
        params.put("cardsSupport", persParams.get("pers.cardsSupport"));
        params.put("pinRetain", (Object)"true");
        params.put("cardLen", persParams.get("pers.cardLen"));
        params.put("cardHex", persParams.get("pers.cardHex"));
        params.put("cardsReadMode", persParams.get("pers.cardsReadMode"));
        params.put("IDReadMode", persParams.get("pers.IDReadMode"));
        return params.toJSONString();
    }

    @RequestMapping(value={"/setParams"}, method={RequestMethod.POST})
    public AppResultMessage setParams(@RequestBody PersAppParamsItem persAppParamsItem) {
        String carHex;
        Boolean pinSupportIncrement;
        Map persOldParams = this.persParamsService.getPersParams();
        HashMap<String, String> persParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getPinLen())) {
            long maxPinLen = this.persPersonService.getMaxPinLenth();
            int pinLen = Integer.parseInt(persAppParamsItem.getPinLen());
            if ((long)pinLen < maxPinLen) {
                return AppResultMessage.failMessage().setRet(String.valueOf(-52));
            }
            persParams.put("pers.pinLen", persAppParamsItem.getPinLen());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getPinSupportLetter())) {
            int personCount;
            Boolean pinSupportLetter = Boolean.parseBoolean(persAppParamsItem.getPinSupportLetter());
            if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getPinSupportIncrement()) && (pinSupportIncrement = Boolean.valueOf(Boolean.parseBoolean(persAppParamsItem.getPinSupportIncrement()))).booleanValue() && pinSupportLetter.booleanValue()) {
                if (Boolean.parseBoolean((String)persOldParams.get("pers.pinSupportIncrement"))) {
                    return AppResultMessage.failMessage().setRet(String.valueOf(-54));
                }
                return AppResultMessage.failMessage().setRet(String.valueOf(-55));
            }
            if (!pinSupportLetter.booleanValue() && (personCount = this.persPersonService.checkPinIsExistLetters()) > 0) {
                return AppResultMessage.failMessage().setRet(String.valueOf(-56));
            }
            persParams.put("pers.pinSupportLetter", persAppParamsItem.getPinSupportLetter());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getPinSupportDefault())) {
            persParams.put("pers.pinSupportDefault", persAppParamsItem.getPinSupportDefault());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getPinSupportIncrement())) {
            if (StringUtils.isBlank((CharSequence)persAppParamsItem.getPinSupportLetter())) {
                Boolean pinSupportLetter = Boolean.parseBoolean((String)persOldParams.get("pers.pinSupportLetter"));
                pinSupportIncrement = Boolean.parseBoolean(persAppParamsItem.getPinSupportIncrement());
                if (pinSupportIncrement.booleanValue() && pinSupportLetter.booleanValue()) {
                    return AppResultMessage.failMessage().setRet(String.valueOf(-54));
                }
            }
            persParams.put("pers.pinSupportIncrement", persAppParamsItem.getPinSupportIncrement());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getCardsSupport())) {
            persParams.put("pers.cardsSupport", persAppParamsItem.getCardsSupport());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getCardLen())) {
            persParams.put("pers.cardLen", persAppParamsItem.getCardLen());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getCardHex()) && !(carHex = (String)persOldParams.get("pers.cardHex")).equals(persAppParamsItem.getCardHex())) {
            long cardNum = this.persCardService.count();
            if (cardNum > 0L) {
                return AppResultMessage.failMessage().setRet(String.valueOf(-58));
            }
            persParams.put("pers.cardHex", persAppParamsItem.getCardHex());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getCardsReadMode())) {
            persParams.put("pers.cardsReadMode", persAppParamsItem.getCardsReadMode());
        }
        if (StringUtils.isNotBlank((CharSequence)persAppParamsItem.getIDReadMode())) {
            persParams.put("pers.IDReadMode", persAppParamsItem.getIDReadMode());
        }
        this.persParamsService.saveItem(persParams);
        return AppResultMessage.successMessage();
    }

    @RequestMapping(value={"/getCardNoByPin"}, method={RequestMethod.POST})
    public String getCardNoByPin(@RequestBody JSONObject obj) {
        PersCardItem cardItem;
        PersPersonItem persPersonItem;
        String pin = obj.getString("username");
        JSONObject json = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)pin) && (persPersonItem = this.persPersonService.getItemByPin(pin)) != null && (cardItem = this.persCardService.getMasterCardByPersonId(persPersonItem.getId())) != null) {
            String cardHex = this.persParamsService.getValByName("pers.cardHex");
            String cardNo = cardItem.getCardNo();
            if (StringUtils.isNotBlank((CharSequence)cardNo)) {
                if (cardHex.equals("1")) {
                    cardNo = new BigInteger(cardNo, 16).toString(10);
                }
                json.put("cardNo", (Object)cardNo);
            }
        }
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/createEncryptedDynamicCode"}, method={RequestMethod.POST})
    public ZKResultMsg createEncryptedDynamicCode(@RequestBody JSONObject obj) {
        String pin = obj.getString("pin");
        String dynamicCode = this.persPersonService.createEncryptedDynamicCode(pin);
        if (StringUtils.isNotBlank((CharSequence)dynamicCode)) {
            ZKResultMsg msg = new ZKResultMsg();
            if (String.valueOf(-59).equals(dynamicCode) || String.valueOf(-60).equals(dynamicCode) || String.valueOf(-22).equals(dynamicCode)) {
                msg.setRet(dynamicCode);
                return msg;
            }
            return new ZKResultMsg((Object)dynamicCode);
        }
        return ZKResultMsg.failMsg((String)"dynamic code encrypt fail", (Object[])new Object[0]);
    }
}

