/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.service.PersApiPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/person"})
@Api(tags={"Person"}, description="person")
public class PersApiV2PersonController {
    private static final Logger log = LoggerFactory.getLogger(PersApiV2PersonController.class);
    @Autowired
    private PersApiPersonService persApiPersonService;
    @Autowired
    private PersPersonService persPersonService;

    @ResponseBody
    @RequestMapping(value={"/getPersonList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Get Person List By PinList And DeptCode", notes="Return Persons List", response=ApiResultMessage.class)
    public ApiResultMessage getPersonList(@RequestParam(name="pins", required=false) String pins, @RequestParam(name="deptCodes", required=false) String deptCodes, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        Pager pager = this.persApiPersonService.getApiPersonByPage(pins, deptCodes, pageNo.intValue(), pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }
}

