/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.api.vo.ApiPersonBaseInfoItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiLeavePersonItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiMembershipItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiPersonItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiPhotoItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiTrainerMonthPlanItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiTrainerPlanDateItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiTrainerWeekPlanItem;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiUpdateUserType;
import com.zkteco.zkbiosecurity.pers.api.vo.PersApiUserType;
import com.zkteco.zkbiosecurity.pers.service.PersApiPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/person"})
@Api(tags={"Person"}, description="person")
public class PersApiPersonController {
    private static final Logger log = LoggerFactory.getLogger(PersApiPersonController.class);
    @Autowired
    private PersApiPersonService persApiPersonService;
    @Autowired
    private PersPersonService persPersonService;

    @ApiOperation(value="Add Person", notes="Create Or Update Person", response=ApiResultMessage.class)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addPerson(@RequestBody PersApiPersonItem person) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addApiPerson(person);
        }
        catch (Exception e) {
            log.error("api person/add error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="Delete Person", notes="Delete Person By Pin", response=ApiResultMessage.class)
    @RequestMapping(value={"/delete/{pin}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage deleteByPin(@PathVariable String pin) {
        ApiResultMessage rs = new ApiResultMessage();
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        try {
            PersPersonItem persPersonItem = this.persPersonService.getItemByPin(pin);
            if (persPersonItem == null) {
                return ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)"pers_api_personNotExist", (Object[])new Object[0]));
            }
            this.persPersonService.deleteByIds(persPersonItem.getId());
        }
        catch (ZKBusinessException e) {
            rs = ApiResultMessage.message((int)-35, (String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("api person/delete error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Get Person", notes="Get Person By Pin", response=ApiResultMessage.class)
    @RequestMapping(value={"/get/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getByPin(@PathVariable String pin) {
        ApiResultMessage rs = null;
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        try {
            rs = this.persApiPersonService.getApiPersonByPin(pin);
        }
        catch (Exception e) {
            log.error("api person/get error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Get Dynamic QR code", notes="Get Dynamic QR code By Pin", response=ApiResultMessage.class)
    @RequestMapping(value={"/getQrCode/{pin}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getQrCodeByPin(@PathVariable String pin) {
        ApiResultMessage rs = new ApiResultMessage();
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        try {
            rs = this.persApiPersonService.getQrCodeByPin(pin);
        }
        catch (ZKBusinessException e) {
            rs = ApiResultMessage.message((int)-22, (String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("api person/getQrCode error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/leave"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Leave Person", notes="Leave Person", response=ApiResultMessage.class)
    public ApiResultMessage leave(@RequestBody PersApiLeavePersonItem persApiLeavePersonItem) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (StringUtils.isBlank((CharSequence)persApiLeavePersonItem.getPin())) {
                return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)persApiLeavePersonItem.getLeaveType())) {
                return ApiResultMessage.message((int)-64, (String)I18nUtil.i18nCode((String)"pers_dimission_leaveType_noNull", (Object[])new Object[0]));
            }
            if (persApiLeavePersonItem.getLeaveDate() == null) {
                return ApiResultMessage.message((int)-66, (String)I18nUtil.i18nCode((String)"pers_dimission_date_noNull", (Object[])new Object[0]));
            }
            rs = this.persApiPersonService.leaveApiPerson(persApiLeavePersonItem);
        }
        catch (Exception e) {
            log.error("api person/leave person error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Add Personnel Basic Information", notes="Create Or Update Person", response=ApiResultMessage.class)
    @RequestMapping(value={"/addPersonnelBasicInfo"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addPersonnelBasicInfo(@RequestBody ApiPersonBaseInfoItem person) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addPersonnelBasicInfo(person);
        }
        catch (Exception e) {
            log.error("api person/add error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Update Personnel Photo", notes="Update Personnel Photo", response=ApiResultMessage.class)
    @RequestMapping(value={"/updatePersonnelPhoto"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage updatePersonnelPhoto(@RequestBody PersApiPhotoItem person) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.updatePersonnelPhoto(person);
        }
        catch (Exception e) {
            log.error("api person/add error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/getPersonList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Get Person List By PinList And DeptCode", notes="Return Persons List", response=ApiResultMessage.class)
    public ApiResultMessage getPersonList(@RequestParam(name="pins", required=false) String pins, @RequestParam(name="deptCodes", required=false) String deptCodes, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List apiPersons = this.persApiPersonService.getApiPersonList(pins, deptCodes, pageNo.intValue(), pageSize.intValue());
        return ApiResultMessage.successMessage((Object)apiPersons);
    }

    @ApiOperation(value="Reinstated", notes="Reinstated Person", response=ApiResultMessage.class)
    @RequestMapping(value={"/reinstated"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage reinstatedPerson(@RequestBody PersApiPersonItem person) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.reinstatedApiPerson(person);
        }
        catch (Exception e) {
            log.error("api person/reinstated error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="MembershipPlan", notes="Membership Plan(month)", response=ApiResultMessage.class)
    @RequestMapping(value={"/membershipPlan"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage membershipPlan(@RequestBody PersApiMembershipItem persMembership) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addMembershipPlan(persMembership);
        }
        catch (Exception e) {
            log.error("api person/membershipPlan error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="UserType", notes="UserType", response=ApiResultMessage.class)
    @RequestMapping(value={"/userType"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addUserType(@RequestBody PersApiUserType persApiUserType) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addUserType(persApiUserType);
        }
        catch (Exception e) {
            log.error("api person/addUserType error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="Get UserType List", notes="Return UserType List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getUserTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getUserTypeList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List apiPersons = this.persApiPersonService.getApiUserTypeList(pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)apiPersons);
    }

    @ApiOperation(value="Update UserType", notes="Updates UserType", response=ApiResultMessage.class)
    @RequestMapping(value={"/updateUserType/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage updateUserType(@RequestBody PersApiUpdateUserType apiUpdateUserType) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.updateUserType(apiUpdateUserType);
        }
        catch (Exception e) {
            log.error("update usertype failed", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="Delete UserType", notes="Delete UserType By Id", response=ApiResultMessage.class)
    @RequestMapping(value={"/deleteUserType/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage deleteUserTypeByIds(@PathVariable String id) {
        ApiResultMessage rs = null;
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return ApiResultMessage.message((int)-110, (String)I18nUtil.i18nCode((String)"User Type Id is null", (Object[])new Object[0]));
            }
            rs = this.persApiPersonService.deleteUserTypeById(id);
        }
        catch (Exception e) {
            log.error("failed to delete the usertype by id", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="Add Trainer Plan", notes="Create Trainer plan by date", response=ApiResultMessage.class)
    @RequestMapping(value={"/addTrainerPlanByDate"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addTrainerPlanDate(@Valid @RequestBody PersApiTrainerPlanDateItem persApiTrainerPlanDateItem) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addTrainerPlanDate(persApiTrainerPlanDateItem);
        }
        catch (Exception e) {
            log.error("failed to create trainer plan by date", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="Add Trainer Week Plan", notes="Create Trainer plan by week", response=ApiResultMessage.class)
    @RequestMapping(value={"/addTrainerPlanByWeek"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addTrainerWeekPlan(@Valid @RequestBody PersApiTrainerWeekPlanItem apiTrainerWeekPlanItem) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addTrainerWeekPlan(apiTrainerWeekPlanItem);
        }
        catch (Exception e) {
            log.error("failed to create trainer plan by week", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="Add Trainer Month Plan", notes="Create Trainer plan by month", response=ApiResultMessage.class)
    @RequestMapping(value={"/addTrainerPlanByMonth"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addTrainerMonthPlan(@Valid @RequestBody PersApiTrainerMonthPlanItem apiTrainerMonthPlanItem) {
        ApiResultMessage rs = null;
        try {
            rs = this.persApiPersonService.addTrainerMonthPlan(apiTrainerMonthPlanItem);
        }
        catch (Exception e) {
            log.error("failed to create trainer plan by week", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        return rs;
    }

    @ApiOperation(value="Get Payment List", notes="Return Payment List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getPayment"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getPaymentList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List paymentReport = this.persApiPersonService.getApiPaymentList(pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)paymentReport);
    }

    @ApiOperation(value="Get PaymentHistory List", notes="Return PaymentHistory List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getPaymentHistory"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getPaymentHistoryList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List paymentReport = this.persApiPersonService.getApiPaymentHistoryList(pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)paymentReport);
    }

    @ApiOperation(value="Get New Membership List", notes="Return New Membership List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getNewMembership"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getNewMembershipList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List membershipReport = this.persApiPersonService.getApiNewMembershipList(pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)membershipReport);
    }

    @ApiOperation(value="Get Expire Membership List", notes="Return Expire Membership List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getExpireMembership"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getExpireMembershipList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List membershipExpireReport = this.persApiPersonService.getApiExpireMembershipList(pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)membershipExpireReport);
    }

    @ApiOperation(value="Get Membership Renewal List", notes="Return Membership Renewal List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getMembershipRenewal"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getMembershipRenewalList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List membershipExpireReport = this.persApiPersonService.getApiMembershipRenewalList(pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)membershipExpireReport);
    }

    @ApiOperation(value="Get Trainer List", notes="Return Trainer List", response=ApiResultMessage.class)
    @RequestMapping(value={"/getTrainerList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getTrainerList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-67, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-68, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        List trainerItems = this.persApiPersonService.getTrainerList(pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)trainerItems);
    }
}

