/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtils {
    public static final String REGEX_SIMPLE_CHINESE = "^[\u4e00-\u9fa5]+$";
    public static final String REGEX_ALPHANUMERIC = "[a-zA-Z0-9]+";
    public static final String REGEX_NAME = "^[A-Za-z0-9\\u4e00-\\u9fa5]+$";
    public static final String REGEX_NUMERIC = "(\\+|-){0,1}(\\d+)([.]?)(\\d*)";
    public static final String REGEX_EMAIL = ".+@.+\\.[a-z]+";
    public static final String REGEX_PHONE = "^(1[1-9])\\d{9}$";
    public static final String REGEX_NUMBER = "[0-9]*";
    private static final int[] factorArr = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
    private static final String[] parityBit = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    public static final String[] UNCHAR = new String[]{"<", ">", "`", "~", "!", "@", "#", "$", "%", "^", "*", "?", "/", "|", "\\", ":", ";", "=", "\"", "'", ",", "--", "+", "\uff0c", "\u3002", "\u3001", "\uff1b", "\u2018", "\u2019", "\u3010", "\u3011", "\u3001", "\u00b7", "\uff01", "\uffe5", "\u2026\u2026", "&", "*", "\uff08", "\uff09", "\u2014\u2014"};

    public static boolean isAlphanumeric(String str) {
        return ValidateUtils.isRegexMatch(str, REGEX_ALPHANUMERIC);
    }

    public static boolean isEmail(String str) {
        return ValidateUtils.isRegexMatch(str, REGEX_EMAIL);
    }

    public static boolean isNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) > '9' || str.charAt(i) < '0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumberLimit(String str, int min, int max) {
        if (!ValidateUtils.isNumber(str)) {
            return false;
        }
        int number = Integer.parseInt(str);
        return number >= min && number <= max;
    }

    public static boolean isNumeric(String str) {
        return ValidateUtils.isRegexMatch(str, REGEX_NUMERIC);
    }

    public static boolean isNumeric(String str, int fractionNum) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        String regex = "(\\+|-){0,1}(\\d+)([.]?)(\\d{0," + fractionNum + "})";
        return Pattern.matches(regex, str);
    }

    public static boolean isPostcode(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return str.length() == 6 && ValidateUtils.isNumber(str);
    }

    public static boolean isStringLimit(String str, int minLength, int maxLength) {
        if (str == null) {
            return false;
        }
        if (minLength < 0) {
            return str.length() <= maxLength;
        }
        if (maxLength < 0) {
            return str.length() >= minLength;
        }
        return str.length() >= minLength && str.length() <= maxLength;
    }

    public static boolean isSimpleChinese(String str) {
        return ValidateUtils.isRegexMatch(str, REGEX_SIMPLE_CHINESE);
    }

    public static boolean isRegexMatch(String str, String regex) {
        return str != null && str.matches(regex);
    }

    public static boolean isMobilePhone(String str) {
        return ValidateUtils.isRegexMatch(str, REGEX_PHONE);
    }

    public static boolean isValiIDCardNo(String certNum) {
        if (StringUtils.isBlank((CharSequence)certNum)) {
            return false;
        }
        String[] varArray = new String[20];
        int lngProduct = 0;
        int intStrLen = certNum.length();
        if (intStrLen == 18) {
            int i = 0;
            while (i < intStrLen) {
                varArray[i] = String.valueOf(certNum.charAt(i));
                if (i != 17 && (Integer.parseInt(varArray[i]) < 0 || Integer.parseInt(varArray[i]) > 9)) {
                    return false;
                }
                if (i < 17) {
                    varArray[i] = String.valueOf(Integer.parseInt(varArray[i]) * factorArr[i]);
                }
                ++i;
            }
            String date = certNum.substring(6, 14);
            if (ValidateUtils.isIDCardDate(date)) {
                return false;
            }
            int i2 = 0;
            while (i2 < 17) {
                lngProduct += Integer.parseInt(varArray[i2]);
                ++i2;
            }
            String intCheckDigit = parityBit[lngProduct % 11];
            if (!String.valueOf(varArray[17]).equals(intCheckDigit)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isIDCardDate(String date) {
        String regex = "[0-9]{6}";
        Boolean result = Pattern.compile(regex).matcher(date).find();
        if (!result.booleanValue()) {
            return false;
        }
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        int[] iaMonthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (year < 1700 || year > 2500) {
            return false;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            iaMonthDays[1] = 29;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        return day >= 1 && day <= iaMonthDays[month - 1];
    }

    public static boolean isSpecialChar(String str) {
        str = str.trim();
        String[] stringArray = UNCHAR;
        int n = UNCHAR.length;
        int n2 = 0;
        while (n2 < n) {
            String charStr = stringArray[n2];
            if (str.indexOf(charStr) >= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

