/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.utils.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StrUtil {
    private static final Pattern numPattern = Pattern.compile("[\\d]+");

    public static String firstUpperCase(String str) {
        if (str == null) {
            return "";
        }
        str = String.valueOf(str.substring(0, 1).toUpperCase(Locale.ENGLISH)) + str.substring(1);
        return str;
    }

    public static String withSingleQuote(String str) {
        String[] array;
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array = str.split(",");
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append("'" + s + "',");
            ++n2;
        }
        return StrUtil.removeLastChar(sb.toString());
    }

    public static String removeLastChar(String str) {
        if (str.length() > 1) {
            return str.substring(0, str.length() - 1);
        }
        return "";
    }

    public static List<String> strToList(String str) {
        return Arrays.asList(str.split(","));
    }

    public static String collectionToStr(Collection<String> strs) {
        if (strs != null && !strs.isEmpty()) {
            StringBuffer sb = new StringBuffer("-1");
            for (String s : strs) {
                sb.append("," + s);
            }
            return sb.toString();
        }
        return "";
    }

    public static String toUpperCase(String str) {
        return str.toUpperCase(Locale.ENGLISH);
    }

    public static String toLowerCase(String str) {
        return str.toLowerCase(Locale.ENGLISH);
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
            ++i;
        }
        return sb.toString();
    }

    public static String replaceString2Star(String content, int frontNum, int afterNum) {
        if (content == null || content.trim().isEmpty()) {
            return null;
        }
        int len = content.length();
        if (frontNum >= len || frontNum < 0 || afterNum >= len || afterNum < 0) {
            return content;
        }
        if (len < 4 || frontNum + afterNum >= len) {
            return content;
        }
        int endIndex = len - afterNum;
        char[] cardChar = content.toCharArray();
        int j = frontNum;
        while (j < endIndex) {
            cardChar[j] = 42;
            ++j;
        }
        return new String(cardChar);
    }

    public static String convertToEncrypt(String value, String encryptMode) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value, encryptMode})) {
            if (encryptMode.matches("[Ss][\\d]+([Ff][\\d]+)?")) {
                value = StrUtil.convertToEncryptBySide(encryptMode, value);
            } else if (encryptMode.matches("\\[[\\d]+(-[\\d]+)?](.)*")) {
                value = StrUtil.convertToEncryptByArea(encryptMode, value);
            }
        }
        return value;
    }

    private static String convertToEncryptBySide(String mode, String value) {
        Matcher matcher = numPattern.matcher(mode);
        int side = 0;
        int fix = 0;
        while (matcher.find()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"S", (CharSequence)("" + mode.charAt(matcher.start() - 1)))) {
                side = Integer.parseInt(matcher.group());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"F", (CharSequence)("" + mode.charAt(matcher.start() - 1)))) continue;
            fix = Integer.parseInt(matcher.group());
        }
        value = side == 0 ? StringUtils.repeat((String)"*", (int)(fix > 0 ? fix : value.length())) : (value.length() <= side ? String.valueOf(value) + StringUtils.repeat((String)"*", (int)(fix > 0 ? fix : 1)) : (value.length() <= 2 * side ? String.valueOf(value.substring(0, side)) + StringUtils.repeat((String)"*", (int)(fix > 0 ? fix : (value.length() - side + 1) / 2)) + value.substring(value.length() - (value.length() - side) / 2) : String.valueOf(value.substring(0, side)) + StringUtils.repeat((String)"*", (int)(fix > 0 ? fix : value.length() - 2 * side)) + value.substring(value.length() - side)));
        return value;
    }

    private static String convertToEncryptByArea(String mode, String value) {
        String[] areas;
        String[] stringArray = areas = mode.split("\\|");
        int n = areas.length;
        int n2 = 0;
        while (n2 < n) {
            String area = stringArray[n2];
            Point point = StrUtil.resolveArea(area);
            Point num = StrUtil.resolveAreaNum(area);
            if (point.getY() == 0) {
                if (value.length() == point.getX()) {
                    value = String.valueOf(value.substring(0, num.getX())) + StrUtil.getEncryptString(num.getX(), num.getY()) + value.substring((num.getY() == 0 ? num.getX() : num.getY()) + 1);
                    break;
                }
            } else if (value.length() >= point.getX() && value.length() <= point.getY()) {
                value = String.valueOf(value.substring(0, num.getX())) + StrUtil.getEncryptString(num.getX(), num.getY()) + value.substring((num.getY() == 0 ? num.getX() : num.getY()) + 1);
                break;
            }
            ++n2;
        }
        return value;
    }

    private static String getEncryptString(int x, int y) {
        return y > 0 ? StringUtils.repeat((String)"*", (int)(y - x + 1)) : "*";
    }

    private static Point resolveAreaNum(String area) {
        int e = 0;
        String s1 = area.trim().split("\\{")[1];
        s1 = s1.substring(0, s1.length() - 1);
        String[] s2 = s1.split(",");
        int s = Integer.parseInt(s2[0].trim());
        if (s2.length > 1 && StringUtils.isNotBlank((CharSequence)s2[1])) {
            e = Integer.parseInt(s2[1].trim());
        }
        return new Point(s, e);
    }

    private static Point resolveArea(String area) {
        int e = 0;
        String s1 = area.trim().split("]")[0];
        s1 = s1.substring(1);
        String[] s2 = s1.split("-");
        int s = Integer.parseInt(s2[0].trim());
        if (s2.length > 1 && StringUtils.isNotBlank((CharSequence)s2[1])) {
            e = "+".equals(s2[1]) ? Integer.MAX_VALUE : Integer.parseInt(s2[1].trim());
        }
        return new Point(s, e);
    }
}

