/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SpringContextUtil
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringContextUtil.applicationContext == null) {
            SpringContextUtil.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return SpringContextUtil.getApplicationContext().getBean(name);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> var1) {
        return SpringContextUtil.getApplicationContext().getBeansOfType(var1);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringContextUtil.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContextUtil.getApplicationContext().getBean(name, clazz);
    }

    public static String getProperty(String key, String def) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String value = request.getParameter(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getSession().getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getServletContext().getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = SpringContextUtil.getApplicationContext().getEnvironment().getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return def;
    }
}

