/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import java.util.Objects;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinUtil {
    private static final Logger logger = LoggerFactory.getLogger(PinyinUtil.class);

    public static String converterToFirstSpell(String chines) {
        String pinyinName = "";
        try {
            char[] nameChar = chines.toCharArray();
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            int i = 0;
            while (i < nameChar.length) {
                pinyinName = nameChar[i] > '\u0080' ? String.valueOf(pinyinName) + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0) : String.valueOf(pinyinName) + nameChar[i];
                ++i;
            }
            pinyinName = pinyinName.replaceAll("u:", "v");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return pinyinName;
    }

    public static String converterToSpell(String chines) {
        String pinyinName = "";
        try {
            if (chines != null && chines.length() > 0) {
                char[] nameChar = chines.toCharArray();
                HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
                defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
                int i = 0;
                while (i < nameChar.length) {
                    if (nameChar[i] > '\u0080') {
                        String[] strings = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat);
                        if (Objects.nonNull(strings)) {
                            pinyinName = String.valueOf(pinyinName) + strings[0];
                        }
                    } else {
                        pinyinName = String.valueOf(pinyinName) + nameChar[i];
                    }
                    ++i;
                }
                pinyinName = pinyinName.replaceAll("u:", "v");
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return pinyinName;
    }
}

