/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Util {
    private static final Logger logger = LoggerFactory.getLogger(MD5Util.class);
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String entype(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug("NoSuchAlgorithmException caught!");
            logger.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
        }
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        int i = 0;
        while (i < byteArray.length) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
            } else {
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
            ++i;
        }
        return md5StrBuff.toString();
    }

    public static String getMD5String(String s) throws Exception {
        return MD5Util.getMD5String(s.getBytes());
    }

    public static boolean checkPassword(String password, String md5PwdStr) throws Exception {
        String md5Pwd = MD5Util.getMD5String(password);
        return md5Pwd.equals(md5PwdStr);
    }

    public static String getFileMD5String(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int numRead = 0;
        MessageDigest messagedigest = MessageDigest.getInstance("MD5");
        while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
            messagedigest.update(buffer, 0, numRead);
        }
        ((InputStream)fis).close();
        return MD5Util.bufferToHex(messagedigest.digest());
    }

    public static String getFileMD5String_old(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        FileChannel channel = fis.getChannel();
        MappedByteBuffer byteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        MessageDigest messagedigest = MessageDigest.getInstance("MD5");
        messagedigest.update(byteBuffer);
        return MD5Util.bufferToHex(messagedigest.digest());
    }

    public static String getMD5String(byte[] bytes) throws Exception {
        MessageDigest messagedigest = MessageDigest.getInstance("MD5");
        messagedigest.update(bytes);
        return MD5Util.bufferToHex(messagedigest.digest());
    }

    private static String bufferToHex(byte[] bytes) {
        return MD5Util.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        int l = m;
        while (l < k) {
            MD5Util.appendHexPair(bytes[l], stringbuffer);
            ++l;
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char charHigh4Bit = hexDigits[(bt & 0xF0) >> 4];
        char charLower4Bit = hexDigits[bt & 0xF];
        stringbuffer.append(charHigh4Bit);
        stringbuffer.append(charLower4Bit);
    }

    private static String beforeDate(Date date, int beforeDays) {
        long installDate = date.getTime() - (long)beforeDays * 86400000L;
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        return ft.format(installDate);
    }

    public static String decrypt(String key) {
        int i = 0;
        while (i < 150000) {
            try {
                Date curTime = new Date();
                String date = MD5Util.beforeDate(curTime, i);
                if (key.equals(MD5Util.getMD5String(date))) {
                    return date;
                }
                date = MD5Util.beforeDate(curTime, -i);
                if (key.equals(MD5Util.getMD5String(date))) {
                    return date;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }
}

