/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.utils.FileType;
import com.zkteco.zkbiosecurity.image.BoxBlurFilter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class ImgEncodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImgEncodeUtil.class);

    public static String encodeBase64(String filePath) {
        InputStream in = null;
        String imgBase64Str = null;
        try {
            try {
                File file = new File(filePath);
                if (file.exists()) {
                    in = new FileInputStream(file);
                    byte[] data = new byte[in.available()];
                    in.read(data);
                    imgBase64Str = new BASE64Encoder().encode(data);
                }
            }
            catch (IOException e) {
                logger.error("exception", (Throwable)e);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    logger.error("exception", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                logger.error("exception", (Throwable)e2);
            }
        }
        return imgBase64Str;
    }

    public static void createZoomImage(File sourceFile, File targetFile, int newWidth, int height) {
        try {
            Thumbnails.of((File[])new File[]{sourceFile}).size(newWidth, height).keepAspectRatio(true).outputFormat("jpg").toFile(targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createZoomImage(File sourceFile, File targetFile) {
        ImgEncodeUtil.createZoomImage(sourceFile, targetFile, 300, 300);
    }

    public static void createZoomImage(String sourceFile, String targetFile) {
        try {
            Thumbnails.of((String[])new String[]{sourceFile}).size(300, 300).keepAspectRatio(true).outputFormat("jpg").toFile(targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void createZoomImage(File sourceFile, File targetFile, int newWidth, float quality) {
        ImgEncodeUtil.createZoomImage(sourceFile, targetFile, newWidth, 300);
    }

    public static boolean isJPGImage(InputStream is) {
        boolean flag;
        block12: {
            flag = false;
            try {
                try {
                    int[] b = new int[4];
                    b[0] = is.read();
                    b[1] = is.read();
                    is.skip(is.available() - 2);
                    b[2] = is.read();
                    b[3] = is.read();
                    is.close();
                    flag = b[0] == 255 && b[1] == 216 && b[2] == 255 && b[3] == 217;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return flag;
    }

    public static boolean isJPGImage(File file) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        return ImgEncodeUtil.isJPGImage(inputStream);
    }

    public static boolean isSupportImageType(File file, FileType ... fileTypes) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        return ImgEncodeUtil.isSupportImageType(inputStream, fileTypes);
    }

    public static boolean isSupportImageType(InputStream inputStream, FileType ... fileTypes) {
        FileType fileType = ImgEncodeUtil.getFileType(inputStream);
        if (ObjectUtils.isEmpty((Object)((Object)fileType))) {
            return false;
        }
        FileType[] fileTypeArray = fileTypes;
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            FileType type = fileTypeArray[n2];
            if (fileType.getValue().equals(type.getValue())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static FileType getFileType(InputStream is) {
        try {
            FileType[] fileTypes;
            byte[] src = new byte[28];
            is.read(src, 0, 28);
            StringBuilder stringBuilder = new StringBuilder("");
            if (src == null || src.length <= 0) {
                return null;
            }
            int i = 0;
            while (i < src.length) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v).toUpperCase();
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
                ++i;
            }
            FileType[] fileTypeArray = fileTypes = FileType.values();
            int n = fileTypes.length;
            int n2 = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }

    private static BufferedImage base64ToBufferedImage(String base64) {
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            byte[] bytes1 = decoder.decode(base64);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes1);
            return ImageIO.read(bais);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String BufferedImageToBase64(BufferedImage bufferedImage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] bytes = baos.toByteArray();
        Base64.Encoder encoder = Base64.getEncoder();
        String base64 = encoder.encodeToString(bytes).trim();
        base64 = base64.replaceAll("\n", "").replaceAll("\r", "");
        return base64;
    }

    public static String base64BoxBlurFilter(String base64) {
        BufferedImage srcImage = ImgEncodeUtil.base64ToBufferedImage(base64);
        if (Objects.isNull(srcImage)) {
            logger.error("base64 to buffer error: " + base64);
            return base64;
        }
        BufferedImage dstImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 1);
        BoxBlurFilter filter = new BoxBlurFilter();
        filter.setRadius(100.0f);
        filter.setVRadius(100.0f);
        filter.setHRadius(100.0f);
        filter.filter(srcImage, dstImage);
        return ImgEncodeUtil.BufferedImageToBase64(dstImage);
    }
}

