/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static Charset defaultCharset = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8).getCharset();

    private HttpUtil() {
    }

    public static String get(String reqURL) {
        return HttpUtil.get(reqURL, null);
    }

    public static String get(String reqURL, Map<String, String> params) {
        Response response = HttpUtil.getAsResponse(reqURL, params, true);
        return response.getStringContent();
    }

    public static String post(String reqURL, String reqData) {
        return HttpUtil.post(reqURL, reqData, "UTF-8");
    }

    public static String post(String reqURL, String reqData, String encodeCharset) {
        StringEntity entity = null;
        if (reqData != null) {
            try {
                entity = new StringEntity(reqData, encodeCharset);
            }
            catch (ZKBusinessException e) {
                log.error("", (Throwable)e);
                throw new ZKBusinessException(e);
            }
        }
        Response response = HttpUtil.postAsResponse(reqURL, entity, true);
        return response.getStringContent();
    }

    public static String post(String reqURL, Map<String, String> params) {
        return HttpUtil.post(reqURL, params, "UTF-8");
    }

    public static String post(String reqURL, Map<String, String> params, String encodeCharset) {
        HttpEntity entity = null;
        if (params != null) {
            entity = HttpUtil.buildUrlEncodeFormEntity(params, encodeCharset);
        }
        Response response = HttpUtil.postAsResponse(reqURL, entity, true);
        return response.getStringContent();
    }

    public static Response postAsResponse(String reqURL, Map<String, String> params) {
        HttpEntity entity = null;
        if (params != null) {
            entity = HttpUtil.buildUrlEncodeFormEntity(params, "UTF-8");
        }
        Response response = HttpUtil.postAsResponse(reqURL, entity, true);
        return response;
    }

    public static Response postAsResponse(String reqURL, Map<String, String> params, String encodeCharset) {
        HttpEntity entity = null;
        if (params != null) {
            entity = HttpUtil.buildUrlEncodeFormEntity(params, encodeCharset);
        }
        Response response = HttpUtil.postAsResponse(reqURL, entity, true);
        return response;
    }

    private static HttpEntity buildUrlEncodeFormEntity(Map<String, String> params, String encodeCharset) {
        UrlEncodedFormEntity entity = null;
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            entity = new UrlEncodedFormEntity(formParams, encodeCharset);
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException(e);
        }
        return entity;
    }

    public static Response getAsResponse(String reqURL, Map<String, String> params, boolean asString) {
        HttpClient httpClient = HttpUtil.getHttpClient(reqURL);
        HttpGet httpReq = new HttpGet(reqURL);
        if (params != null && !params.isEmpty()) {
            BasicHttpParams httpParams = new BasicHttpParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                httpParams.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            httpReq.setParams((HttpParams)httpParams);
        }
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpReq);
            log.debug("\u8bf7\u6c42\u5730\u5740: " + httpReq.getURI());
            Response retResponse = new Response(asString);
            StatusLine statusLine = response.getStatusLine();
            log.debug("\u54cd\u5e94\u72b6\u6001: " + statusLine);
            retResponse.setStatusLine(statusLine);
            Header[] headers = response.getAllHeaders();
            retResponse.setHeaders(headers);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Charset respCharset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                retResponse.setCharset(respCharset);
                log.debug("\u54cd\u5e94\u7f16\u7801: " + respCharset);
                if (asString) {
                    String content = EntityUtils.toString((HttpEntity)entity, (Charset)respCharset);
                    retResponse.setStringContent(content);
                    log.debug("\u54cd\u5e94\u5185\u5bb9: " + content);
                } else {
                    retResponse.setByteArrayContent(EntityUtils.toByteArray((HttpEntity)entity));
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            Response response2 = retResponse;
            return response2;
        }
        catch (ClientProtocolException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_protocolError", e);
        }
        catch (ConnectTimeoutException cte) {
            log.error("", (Throwable)cte);
            throw new ZKBusinessException("common_net_timeout", cte);
        }
        catch (SocketTimeoutException ste) {
            log.error("", (Throwable)ste);
            throw new ZKBusinessException("common_net_timeout", ste);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_connError", e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static Response postAsResponse(String reqURL, HttpEntity reqEntity, boolean asString) {
        HttpClient httpClient = HttpUtil.getHttpClient(reqURL);
        try {
            Header[] hs;
            HttpPost httpPost = new HttpPost(reqURL);
            if (reqEntity != null) {
                httpPost.setEntity(reqEntity);
            }
            log.debug("\u8bf7\u6c42\u5730\u5740: " + httpPost.getURI());
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            if ((statusLine.getStatusCode() == 302 || statusLine.getStatusCode() == 301) && (hs = response.getHeaders("Location")).length > 0) {
                Response response2 = HttpUtil.postAsResponse(hs[0].getValue(), reqEntity, asString);
                return response2;
            }
            Response retResponse = new Response(asString);
            log.debug("\u54cd\u5e94\u72b6\u6001: " + statusLine);
            retResponse.setStatusLine(statusLine);
            Header[] headers = response.getAllHeaders();
            retResponse.setHeaders(headers);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Charset respCharset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                retResponse.setCharset(respCharset);
                log.debug("\u54cd\u5e94\u7f16\u7801: " + respCharset);
                if (asString) {
                    String content = EntityUtils.toString((HttpEntity)entity, (Charset)respCharset);
                    retResponse.setStringContent(content);
                    log.debug("\u54cd\u5e94\u5185\u5bb9: " + content);
                } else {
                    retResponse.setByteArrayContent(EntityUtils.toByteArray((HttpEntity)entity));
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            Response response3 = retResponse;
            return response3;
        }
        catch (ClientProtocolException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_protocolError", e);
        }
        catch (ConnectTimeoutException cte) {
            log.error("", (Throwable)cte);
            throw new ZKBusinessException("common_net_timeout", cte);
        }
        catch (SocketTimeoutException ste) {
            log.error("", (Throwable)ste);
            throw new ZKBusinessException("common_net_timeout", ste);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_connError", e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private static HttpClient getHttpClient(String reqURL) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.connection.timeout", (Object)60000);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)60000);
        if (reqURL.startsWith("https")) {
            try {
                X509TrustManager trustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                X509HostnameVerifier hostnameVerifier = new X509HostnameVerifier(){

                    public void verify(String host, SSLSocket ssl) throws IOException {
                    }

                    public void verify(String host, X509Certificate cert) throws SSLException {
                    }

                    public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                    }

                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                };
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{trustManager}, null);
                SSLSocketFactory socketFactory = new SSLSocketFactory(sslContext, hostnameVerifier);
                httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
                return httpClient;
            }
            catch (Exception e) {
                log.error("create HttpClient with ssl error", (Throwable)e);
                throw new ZKBusinessException(e);
            }
        }
        return httpClient;
    }

    public static class Response {
        private StatusLine statusLine;
        private Charset charset;
        private byte[] byteArrayContent;
        private String stringContent;
        private boolean asString = true;
        private Map<String, String> headers = new HashMap<String, String>();

        public Response(boolean asString) {
            this.asString = asString;
        }

        public boolean isAsString() {
            return this.asString;
        }

        public byte[] getByteArrayContent() {
            return this.byteArrayContent;
        }

        public void setByteArrayContent(byte[] byteArrayContent) {
            this.byteArrayContent = byteArrayContent;
        }

        public String getStringContent() {
            return this.stringContent;
        }

        public void setStringContent(String stringContent) {
            this.stringContent = stringContent;
        }

        public StatusLine getStatusLine() {
            return this.statusLine;
        }

        public void setStatusLine(StatusLine statusLine) {
            this.statusLine = statusLine;
        }

        public String getHeader(String headerKey) {
            return this.headers.get(headerKey);
        }

        public Map<String, String> getHeadesr() {
            return this.headers;
        }

        public void setHeaders(Header[] headers) {
            if (headers != null) {
                Header[] headerArray = headers;
                int n = headers.length;
                int n2 = 0;
                while (n2 < n) {
                    Header h = headerArray[n2];
                    this.headers.put(h.getName(), h.getValue());
                    ++n2;
                }
            }
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }
    }
}

