/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final String separator = "/";
    public static final String uploadFilePath = "fileresource";
    public static final String thumbPath = "thumb";
    public static final String cropFacePath = "cropface";
    public static String systemFilePath;
    private static final int PHOTO_MAX_SIZE_BYTE = 0xA00000;

    @Value(value="${system.filePath:BioSecurityFile}")
    public void setSystemFilePath(String systemFilePath) {
        FileUtils.systemFilePath = systemFilePath;
    }

    public static String createUploadFileRootPath(String module, String business) {
        return "fileresource/" + module + separator + business + separator + DateUtil.dateToString(new Date(), DateUtil.DateStyle.YYYY_MM_DD) + separator;
    }

    public static boolean deleteFile(String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return false;
        }
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }

    @Deprecated
    public static void saveFile(String filePath, String fileName, MultipartFile uploadFile) {
        FileUtils.saveMultipartFile(filePath, fileName, uploadFile, true);
    }

    public static String saveFileToServer(String module, String business, String fileName, MultipartFile uploadFile, boolean thumbPic) {
        if (StringUtils.hasLength((String)fileName)) {
            String filePath = FileUtils.createUploadFileRootPath(module, business);
            FileUtils.saveMultipartFile(filePath, fileName, uploadFile, thumbPic);
            fileName = separator + filePath + fileName;
        }
        return fileName;
    }

    public static void saveMultipartFile(String filePath, String fileName, MultipartFile uploadFile, boolean thumbPic) {
        try {
            if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
                String fullPath = String.valueOf(systemFilePath) + separator + filePath;
                File file = new File(new File(fullPath), fileName);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                uploadFile.transferTo(new File(file.getAbsolutePath()));
                if (thumbPic) {
                    FileUtils.createThumbPic(file, filePath, fileName);
                }
            }
        }
        catch (Exception e) {
            new ZKBusinessException("-------------  Save  File  Error :" + e.getMessage());
        }
    }

    public static void saveMultipartFile(String fullPath, String fileName, MultipartFile uploadFile) {
        try {
            if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
                File file = new File(new File(fullPath), fileName);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                uploadFile.transferTo(new File(file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            new ZKBusinessException("-------------  Save  File  Error :" + e.getMessage());
        }
    }

    private static void createThumbPic(File originalFile, String filePath, String fileName) throws IOException {
        if (fileName.toLowerCase().matches(".*?(jpg|jpeg|png|bmp|gif)")) {
            String fullThumbPath = String.valueOf(systemFilePath) + separator + filePath + separator + thumbPath;
            File thumbFile = new File(new File(fullThumbPath), fileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + ".jpg");
            if (!thumbFile.getParentFile().exists()) {
                thumbFile.getParentFile().mkdirs();
            }
            if (thumbFile.exists()) {
                thumbFile.delete();
            }
            ImgEncodeUtil.createZoomImage(originalFile, thumbFile);
        }
    }

    public static String getLocalFullPath(String relativePath) {
        if (!StringUtils.hasText((String)relativePath)) {
            return null;
        }
        String fullPath = String.valueOf(systemFilePath) + separator + relativePath;
        File file = new File(fullPath);
        return file.getAbsolutePath();
    }

    public static boolean fileExists(String relativePath) {
        String fullPath = String.valueOf(systemFilePath) + separator + relativePath;
        File file = new File(fullPath);
        return file.exists();
    }

    public static String getThumbPath(String originalFilePath) {
        if (StringUtils.hasLength((String)originalFilePath)) {
            int index = originalFilePath.lastIndexOf(separator);
            if (index != -1 && !originalFilePath.startsWith("http")) {
                return String.valueOf(originalFilePath.substring(0, index)) + separator + thumbPath + originalFilePath.substring(index);
            }
            return originalFilePath;
        }
        return null;
    }

    public static int getCropFaceCount(String business) {
        int cropFaceCount = 0;
        File file = new File(String.valueOf(systemFilePath) + separator + uploadFilePath + separator + business + separator + cropFacePath);
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                cropFaceCount += f.listFiles().length;
                ++n2;
            }
        }
        return cropFaceCount;
    }

    public static String getCropFacePath(String business, String fileName) {
        if (StringUtils.hasLength((String)fileName)) {
            return "fileresource/" + business + separator + cropFacePath + separator + fileName;
        }
        return null;
    }

    public static int getCropFaceCount(String business, String pin) {
        File file = new File(String.valueOf(systemFilePath) + separator + FileUtils.getCropFacePath(business, pin));
        if (file.exists()) {
            return file.listFiles().length;
        }
        return 0;
    }

    public static void saveFile(String filePath, String fileName, String base64ImgStr, boolean thumbPic) {
        block15: {
            OutputStream out = null;
            try {
                try {
                    String fullPath = String.valueOf(systemFilePath) + separator + filePath;
                    File file = new File(new File(fullPath), fileName);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (file.exists()) {
                        file.delete();
                    }
                    out = new FileOutputStream(file);
                    out.write(Base64.getDecoder().decode(base64ImgStr));
                    out.flush();
                    out.close();
                    if (thumbPic) {
                        FileUtils.createThumbPic(file, filePath, fileName);
                    }
                }
                catch (Exception e) {
                    new ZKBusinessException("-------------  Save  File  Error :" + e.getMessage());
                    if (out == null) break block15;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static String saveFileToServer(String module, String business, String fileName, MultipartFile uploadFile) {
        if (StringUtils.hasLength((String)fileName)) {
            String filePath = FileUtils.createUploadFileRootPath(module, business);
            FileUtils.saveFile(filePath, fileName, uploadFile);
            fileName = separator + filePath + fileName;
        }
        return fileName;
    }

    public static String saveFileToServer(String module, String business, String fileName, String base64ImgStr) {
        if (StringUtils.hasLength((String)fileName)) {
            String filePath = FileUtils.createUploadFileRootPath(module, business);
            FileUtils.saveFile(filePath, fileName, base64ImgStr, true);
            fileName = separator + filePath + fileName;
        }
        return fileName;
    }

    public static String saveCropFaceToServer(String business, String pin, String fileName, String base64ImgStr) {
        if (StringUtils.hasLength((String)pin)) {
            String filePath = FileUtils.getCropFacePath(business, pin);
            FileUtils.saveFile(filePath, fileName, base64ImgStr, false);
            fileName = separator + filePath + fileName;
        }
        return fileName;
    }

    public static String getFileSize(MultipartFile file) {
        DecimalFormat df = new DecimalFormat("#.##");
        String fileSiz = file.getSize() / 1024L > 1000L ? String.valueOf(df.format((double)file.getSize() / 1024.0 / 1024.0)) + "MB" : df.format(file.getSize() / 1024L);
        return fileSiz;
    }

    public static String getFileMd5Value(String filePath) {
        try {
            return DigestUtils.md5Hex((InputStream)new FileInputStream(filePath));
        }
        catch (IOException e) {
            throw new ZKBusinessException("-------------  File Path Error :" + e.getMessage());
        }
    }

    public static String getFileBase64Str(String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return "";
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return "";
        }
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            inputFile.read(buffer);
            String string = Base64.getEncoder().encodeToString(buffer);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("-------------  File Path Error :" + e.getMessage());
        }
        finally {
            try {
                if (Objects.nonNull(inputFile)) {
                    inputFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!StringUtils.hasText((String)dir)) {
            return false;
        }
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile() ? !(flag = FileUtils.deleteFile(files[i].getAbsolutePath())) : !(flag = FileUtils.deleteDirectory(files[i].getAbsolutePath()))) break;
                ++i;
            }
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static HttpServletResponse downLoadFiles(String tempPath, File[] files, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ZipOutputStream zipOut = null;
        FileOutputStream fileOutputStr = null;
        try {
            File file = new File(tempPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            response.reset();
            fileOutputStr = new FileOutputStream(file);
            zipOut = new ZipOutputStream(fileOutputStr);
            FileUtils.zipFiles(files, zipOut);
            zipOut.close();
            fileOutputStr.close();
            HttpServletResponse httpServletResponse = FileUtils.downloadZip(file, response);
            return httpServletResponse;
        }
        catch (Exception e) {
            logger.error("exception:", (Throwable)e);
        }
        finally {
            if (zipOut != null) {
                zipOut.close();
            }
            if (fileOutputStr != null) {
                fileOutputStr.close();
            }
        }
        return response;
    }

    public static void zipFiles(File[] files, ZipOutputStream outputStream) {
        int size = files.length;
        int i = 0;
        while (i < size) {
            FileUtils.zipFile(files[i], outputStream);
            ++i;
        }
    }

    public static void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block26: {
            FileInputStream inputStream = null;
            BufferedInputStream bufferInput = null;
            try {
                try {
                    if (!inputFile.exists()) break block26;
                    if (inputFile.isFile()) {
                        int index;
                        inputStream = new FileInputStream(inputFile);
                        bufferInput = new BufferedInputStream(inputStream, 512);
                        ZipEntry entry = new ZipEntry(inputFile.getName());
                        ouputStream.putNextEntry(entry);
                        byte[] buffer = new byte[512];
                        while ((index = bufferInput.read(buffer)) != -1) {
                            ouputStream.write(buffer, 0, index);
                        }
                        bufferInput.close();
                        inputStream.close();
                        break block26;
                    }
                    try {
                        File[] files = inputFile.listFiles();
                        if (files != null) {
                            int i = 0;
                            while (i < files.length) {
                                FileUtils.zipFile(files[i], ouputStream, inputFile.getName());
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("exception:", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("exception:", (Throwable)e);
                    if (bufferInput != null) {
                        try {
                            bufferInput.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (inputStream == null) break block26;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferInput != null) {
                    try {
                        bufferInput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void zipFile(File inputFile, ZipOutputStream ouputStream, String path) {
        block26: {
            FileInputStream inputStream = null;
            BufferedInputStream bufferInput = null;
            try {
                try {
                    if (!inputFile.exists()) break block26;
                    if (inputFile.isFile()) {
                        int index;
                        inputStream = new FileInputStream(inputFile);
                        bufferInput = new BufferedInputStream(inputStream, 512);
                        ZipEntry entry = new ZipEntry(String.valueOf(path) + File.separator + inputFile.getName());
                        ouputStream.putNextEntry(entry);
                        byte[] buffer = new byte[512];
                        while ((index = bufferInput.read(buffer)) != -1) {
                            ouputStream.write(buffer, 0, index);
                        }
                        bufferInput.close();
                        inputStream.close();
                        break block26;
                    }
                    try {
                        File[] files = inputFile.listFiles();
                        if (files != null) {
                            int i = 0;
                            while (i < files.length) {
                                FileUtils.zipFile(files[i], ouputStream, String.valueOf(path) + File.separator + inputFile.getName());
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("exception:", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("exception:", (Throwable)e);
                    if (bufferInput != null) {
                        try {
                            bufferInput.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (inputStream == null) break block26;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferInput != null) {
                    try {
                        bufferInput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static HttpServletResponse downloadZip(File file, HttpServletResponse response) {
        InputStream fis = null;
        OutputStream toClient = null;
        try {
            try {
                fis = new BufferedInputStream(new FileInputStream(file.getPath()));
                response.reset();
                toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
                byte[] buffer = new byte[1024];
                int i = -1;
                while ((i = fis.read(buffer)) != -1) {
                    toClient.write(buffer, 0, i);
                }
                fis.close();
                toClient.flush();
                toClient.close();
            }
            catch (IOException ex) {
                logger.error("exception:", (Throwable)ex);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (toClient != null) {
                        toClient.close();
                    }
                }
                catch (Exception e) {
                    logger.error("exception:", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (toClient != null) {
                    toClient.close();
                }
            }
            catch (Exception e) {
                logger.error("exception:", (Throwable)e);
            }
        }
        return response;
    }

    public static Integer imageSize(String image) {
        Integer equalIndex = image.indexOf("=");
        if (image.indexOf("=") > 0) {
            image = image.substring(0, equalIndex);
        }
        Integer strLength = image.length();
        Integer size = strLength - strLength / 8 * 2;
        return size;
    }

    public static boolean isOverSize(String image, Integer allowSize) {
        return FileUtils.imageSize(image) > (allowSize == null ? 0xA00000 : allowSize);
    }

    public static String saveByte2Image(String module, String business, String fileName, byte[] uploadFile) {
        block16: {
            if (StringUtils.hasLength((String)fileName)) {
                String filePath = FileUtils.createUploadFileRootPath(module, business);
                String fullPath = String.valueOf(systemFilePath) + separator + filePath;
                File file = new File(new File(fullPath), fileName);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                ByteArrayInputStream in = new ByteArrayInputStream(uploadFile);
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(file);
                        int len = 0;
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                        }
                        fos.flush();
                        fileName = separator + filePath + fileName;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (fos == null) break block16;
                        try {
                            fos.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return fileName;
    }
}

