/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.HttpUtil;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileEncryptUtil {
    private static final Logger log = LoggerFactory.getLogger(FileEncryptUtil.class);
    public static String systemFilePath;
    private static boolean isOpenSecurityEncrypt;

    @Value(value="${system.filePath:BioSecurityFile}")
    public void setSystemFilePath(String systemFilePath) {
        FileEncryptUtil.systemFilePath = systemFilePath;
    }

    @Value(value="${system.data.security-encrypt:false}")
    public void setIsOpenSecurityEncrypt(boolean isOpenSecurityEncrypt) {
        FileEncryptUtil.isOpenSecurityEncrypt = isOpenSecurityEncrypt;
    }

    public static String encryptFileByPath(String filePath) {
        if (isOpenSecurityEncrypt && StringUtils.isNotBlank((CharSequence)filePath)) {
            String randomSey = System.getProperty("system.security.randomsey");
            if (StringUtils.isBlank((CharSequence)randomSey)) {
                return "";
            }
            FileInputStream inputFile = null;
            try {
                String srcFilePath = String.valueOf(systemFilePath) + File.separator + filePath;
                File srcFile = new File(srcFilePath);
                if (!srcFile.getParentFile().exists()) {
                    srcFile.getParentFile().mkdirs();
                }
                if (!srcFile.exists()) {
                    log.info("======AesPhotoUtil encPhotoByPath() photo file not exixt!=======");
                    return "";
                }
                try {
                    randomSey = FoldexUtil.decryptRandomString((String)randomSey);
                    String randomIv = randomSey.substring(8, 24);
                    inputFile = new FileInputStream(srcFile);
                    byte[] encBuffer = FoldexUtil.encryptFileWithType((InputStream)inputFile, (String)randomSey, (String)randomIv);
                    FileEncryptUtil.saveByte2File(filePath, encBuffer);
                }
                catch (Exception e) {
                    log.error("=====AesPhotoUtil encPhotoByPath() encrypt file error\uff1a=====", (Throwable)e);
                }
            }
            finally {
                if (Objects.nonNull(inputFile)) {
                    try {
                        inputFile.close();
                    }
                    catch (IOException e) {
                        log.error("exception", (Throwable)e);
                    }
                }
            }
        }
        return filePath;
    }

    public static String saveByte2File(String filePath, byte[] uploadFile) {
        block24: {
            if (isOpenSecurityEncrypt && StringUtils.isNotBlank((CharSequence)filePath) && Objects.nonNull(uploadFile)) {
                String fullPath = String.valueOf(systemFilePath) + File.separator + filePath;
                File file = new File(fullPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                ByteArrayInputStream in = new ByteArrayInputStream(uploadFile);
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(file);
                        int len = 0;
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                        }
                        fos.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e2) {
                                log.error("exception", (Throwable)e2);
                            }
                        }
                        if (fos == null) break block24;
                        try {
                            fos.close();
                        }
                        catch (IOException e3) {
                            log.error("exception", (Throwable)e3);
                        }
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            log.error("exception", (Throwable)e);
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            log.error("exception", (Throwable)e);
                        }
                    }
                }
            }
        }
        return filePath;
    }

    public static String getDecryptFileBase64(String encFilePath) {
        byte[] buffer;
        String decFileBase64Str = "";
        decFileBase64Str = isOpenSecurityEncrypt ? ((buffer = FileEncryptUtil.getDecryptFile(encFilePath)) != null && buffer.length > 0 ? Base64.getEncoder().encodeToString(buffer) : FileUtil.getFileBase64Str(FileUtil.getLocalFullPath(encFilePath))) : FileUtil.getFileBase64Str(FileUtil.getLocalFullPath(encFilePath));
        return decFileBase64Str;
    }

    public static byte[] getDecryptFile(String encFilePath) {
        byte[] buffer = null;
        if (isOpenSecurityEncrypt) {
            try {
                String randomSey = System.getProperty("system.security.randomsey");
                if (StringUtils.isBlank((CharSequence)randomSey)) {
                    return buffer;
                }
                if (StringUtils.isNotBlank((CharSequence)encFilePath)) {
                    encFilePath = String.valueOf(systemFilePath) + File.separator + encFilePath;
                    File encFile = new File(encFilePath);
                    if (!encFile.exists()) {
                        log.info("======AesPhotoUtil getDecPhoto() decode file not exixt!FilePath:{}=======", (Object)encFilePath);
                        return buffer;
                    }
                    randomSey = FoldexUtil.decryptRandomString((String)randomSey);
                    String randomIv = randomSey.substring(8, 24);
                    FileInputStream fileInputStream = new FileInputStream(encFile);
                    buffer = FoldexUtil.decryptFileWithType((InputStream)fileInputStream, (String)randomSey, (String)randomIv);
                }
            }
            catch (Exception e) {
                log.error("=====AesPhotoUtil getDecPhoto() decode file error\uff1a=====", (Throwable)e);
            }
        }
        return buffer;
    }

    public static byte[] getDecryptNetFile(String httpFilePath) {
        byte[] buffer = null;
        if (isOpenSecurityEncrypt) {
            try {
                HttpUtil.Response response;
                byte[] fileResult;
                String randomSey = System.getProperty("system.security.randomsey");
                if (StringUtils.isBlank((CharSequence)randomSey)) {
                    return buffer;
                }
                if (StringUtils.isNotBlank((CharSequence)httpFilePath) && (httpFilePath.startsWith("http") || httpFilePath.startsWith("https")) && (fileResult = (response = HttpUtil.getAsResponse(httpFilePath, null, false)).getByteArrayContent()) != null && fileResult.length > 0) {
                    randomSey = FoldexUtil.decryptRandomString((String)randomSey);
                    String randomIv = randomSey.substring(8, 24);
                    ByteArrayInputStream fileInputStream = new ByteArrayInputStream(fileResult);
                    buffer = FoldexUtil.decryptFileWithType((InputStream)fileInputStream, (String)randomSey, (String)randomIv);
                }
            }
            catch (Exception e) {
                log.error("=====AesPhotoUtil getDecPhoto() decode file error\uff1a=====", (Throwable)e);
            }
        }
        return buffer;
    }
}

