/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.sun.crypto.provider.SunJCE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncrypAESUtil {
    private static Logger logger = LoggerFactory.getLogger(EncrypAESUtil.class);
    private static int BUFFER_SIZE = 10240;
    private static KeyGenerator keygen;
    private static SecretKey deskey;
    private static Cipher cipher;
    private static Cipher cipherDe;

    static {
        Security.addProvider(new SunJCE());
        try {
            keygen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            String key = "cipher";
            secureRandom.setSeed(key.getBytes());
            keygen.init(128, secureRandom);
            deskey = keygen.generateKey();
            cipher = Cipher.getInstance("AES");
            cipher.init(1, deskey);
            cipherDe = Cipher.getInstance("AES");
            cipherDe.init(2, deskey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encrytor(String str) {
        try {
            byte[] src = str.getBytes("utf-8");
            byte[] cipherByte = cipher.doFinal(src);
            return cipherByte;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encrytToString(String str) {
        byte[] bytes = EncrypAESUtil.encrytor(str);
        return EncrypAESUtil.parseByte2HexStr(bytes);
    }

    public static byte[] decryptor(byte[] buff) {
        try {
            byte[] cipherByte = cipherDe.doFinal(buff);
            return cipherByte;
        }
        catch (Exception e) {
            try {
                try {
                    logger.debug("+++" + buff.length + "+++" + new String(buff, "utf-8").toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            catch (Throwable throwable) {}
            throw new RuntimeException(e);
        }
    }

    public static String decryptToString(String str) {
        try {
            byte[] bytes = EncrypAESUtil.parseHexStr2Byte(str);
            return new String(EncrypAESUtil.decryptor(bytes), "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buf.length) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        int i = 0;
        while (i < hexStr.length() / 2) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String msg = "Company Name";
        logger.debug("\u660e\u6587\u662f:" + msg);
        String s = EncrypAESUtil.encrytToString(msg);
        logger.debug("\u52a0\u5bc6\u540e:" + s);
        System.out.println("\u89e3\u5bc6\u540e:" + EncrypAESUtil.decryptToString("A85B321BDCACC5599EB7D80EE7779C94"));
    }

    public static void encryptFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            CipherOutputStream out = null;
            FileInputStream fin = null;
            try {
                try {
                    int count;
                    File tmp = new File(String.valueOf(file.getParentFile().getPath()) + File.separator + System.currentTimeMillis() + "_" + file.getName());
                    out = new CipherOutputStream(new FileOutputStream(tmp), cipher);
                    byte[] buffer = new byte[BUFFER_SIZE];
                    fin = new FileInputStream(file);
                    while ((count = fin.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                    }
                    out.close();
                    fin.close();
                    out = null;
                    fin = null;
                    file.delete();
                    tmp.renameTo(file);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                }
            }
        }
    }

    public static void decryptFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            CipherInputStream cin = null;
            FileOutputStream fos = null;
            try {
                try {
                    int count;
                    File tmp = new File(String.valueOf(file.getParentFile().getPath()) + File.separator + System.currentTimeMillis() + "_" + file.getName());
                    cin = new CipherInputStream(new FileInputStream(file), cipherDe);
                    byte[] buffer = new byte[BUFFER_SIZE];
                    fos = new FileOutputStream(tmp);
                    while ((count = cin.read(buffer)) > 0) {
                        fos.write(buffer, 0, count);
                    }
                    fos.close();
                    cin.close();
                    cin = null;
                    fos = null;
                    file.delete();
                    tmp.renameTo(file);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    try {
                        if (cin != null) {
                            cin.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (cin != null) {
                        cin.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                }
            }
        }
    }
}

