/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.utils;

import com.zkteco.zkbiosecurity.core.utils.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil
implements Comparator<String> {
    private static final Logger log = LoggerFactory.getLogger(VersionUtil.class);
    static String DASH_DELIM = "_";
    static String DOT_DELIM = ".";
    private static Properties prop = new Properties();

    static {
        List<InputStream> resources = ResourceUtil.loadResourcesAsInputStream("git.properties");
        for (InputStream resource : resources) {
            try {
                prop.load(resource);
            }
            catch (IOException e) {
                log.info("read git.properties error!");
            }
        }
    }

    public static String getReleaseGitTags(String module) {
        String version2;
        String version = null;
        if (prop.get(String.valueOf(module) + ".git.closest.tag.name") != null) {
            version2 = "" + prop.get(String.valueOf(module) + ".git.closest.tag.name");
            Pattern keyPattern1 = Pattern.compile("(v|V{1})[0-9]+\\.[0-9]+\\.[0-9]+");
            if (keyPattern1.matcher(version2).find()) {
                version = version2;
            }
        }
        if (prop.get(String.valueOf(module) + ".git.build.version") != null) {
            version2 = "" + prop.get(String.valueOf(module) + ".git.build.version");
            version = "v" + version2.split("-")[0];
        }
        log.info("module = {} current version = {}", (Object)module, version);
        return version;
    }

    public static String getPomBuildVersion(String module) {
        if (prop.get(String.valueOf(module) + ".git.build.version") != null) {
            String version = "" + prop.get(String.valueOf(module) + ".git.build.version");
            return version;
        }
        return null;
    }

    public static boolean isUndoByCompareVersion(String oldVersion, String newVersion) {
        return VersionUtil.compareVersions(oldVersion, newVersion) == 1;
    }

    public static int compareVersions(String oldVersion, String newVersion) {
        return new VersionUtil().compare(newVersion, oldVersion);
    }

    @Override
    public int compare(String newVersion, String oldVersion) {
        String[] valueSplit2;
        String matchStr = "(v|V{1})[0-9]+\\.[0-9]+\\.[0-9]+";
        Pattern keyPattern1 = Pattern.compile(matchStr);
        oldVersion = oldVersion.trim();
        newVersion = newVersion.trim();
        if (!keyPattern1.matcher(oldVersion).find() || !keyPattern1.matcher(newVersion).find()) {
            return -2;
        }
        if (oldVersion.indexOf(DASH_DELIM) > -1) {
            oldVersion = oldVersion.split(DASH_DELIM)[0];
        }
        if (newVersion.indexOf(DASH_DELIM) > -1) {
            newVersion = newVersion.split(DASH_DELIM)[0];
        }
        oldVersion = oldVersion.replace("v", "").replace("V", "");
        String[] valueSplit1 = (newVersion = newVersion.replace("v", "").replace("V", "")).split("[.]");
        int minLength = valueSplit1.length;
        if (minLength > (valueSplit2 = oldVersion.split("[.]")).length) {
            minLength = valueSplit2.length;
        }
        int i = 0;
        while (i < minLength) {
            int value2;
            int value1 = Integer.parseInt(valueSplit1[i]);
            if (value1 > (value2 = Integer.parseInt(valueSplit2[i]))) {
                return 1;
            }
            if (value1 < value2) {
                return -1;
            }
            ++i;
        }
        return valueSplit1.length - valueSplit2.length;
    }
}

