/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import org.springframework.util.Base64Utils;
import sun.misc.BASE64Decoder;

public class Base64Util {
    public static String getBase64(String str) {
        String encodedText = null;
        byte[] textByte = null;
        try {
            if (str != null) {
                textByte = str.getBytes("UTF-8");
                encodedText = Base64Util.encode(textByte);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodedText;
    }

    public static String getFromBase64(String str) {
        String encodedText = null;
        byte[] textByte = null;
        try {
            if (str != null) {
                textByte = Base64Util.decode(str);
                encodedText = new String(textByte, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodedText;
    }

    public static String encode(byte[] data) {
        String encodedText = null;
        if (data != null) {
            encodedText = Base64.getEncoder().encodeToString(data);
        }
        return encodedText;
    }

    public static byte[] decode(String str) {
        byte[] textByte = null;
        if (str != null) {
            textByte = Base64.getDecoder().decode(str);
        }
        return textByte;
    }

    public static boolean generateImage(String imgStr, String imgFilePath) {
        if (imgStr == null) {
            return false;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] bytes = decoder.decodeBuffer(imgStr);
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] < 0) {
                    int n = i;
                    bytes[n] = (byte)(bytes[n] + 256);
                }
                ++i;
            }
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(bytes);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getImageStrFromUrl(String imgURL) {
        byte[] data = Base64Util.getImageFromNetByUrl(imgURL);
        String content = Base64Utils.encodeToString((byte[])data);
        return content;
    }

    public static byte[] getImageFromNetByUrl(String strUrl) {
        try {
            URL url = new URL(strUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(20000);
            InputStream inStream = conn.getInputStream();
            byte[] btImg = Base64Util.readInputStream(inStream);
            return btImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }
}

