/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.controller;

import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseController {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    protected int getPageNo() {
        String posStart = this.request.getParameter("posStart");
        int pageSize = this.getPageSize();
        int pageNo = posStart == null ? 0 : Integer.valueOf(posStart) / pageSize;
        return pageNo;
    }

    protected int getPageSize() {
        String count = this.request.getParameter("pageSize");
        int pageSize = count == null ? 50 : Integer.valueOf(count);
        return pageSize;
    }

    protected long getLimitCount() {
        String count = this.request.getParameter("limitCount");
        long limitCount = StringUtils.isBlank((CharSequence)count) ? 0L : Long.valueOf(count);
        return limitCount > 0L ? limitCount + 1L : limitCount;
    }

    protected boolean getPageList() {
        String pageList = this.request.getParameter("pageList");
        return !Boolean.TRUE.toString().equals(pageList);
    }

    protected String getToken() {
        String tokenHeader = this.request.getHeader("Access-Token");
        return tokenHeader;
    }

    protected SecuritySubject getCurrentSubject() {
        SecuritySubject securitySubject = (SecuritySubject)this.request.getSession().getAttribute("user");
        return securitySubject;
    }
}

