/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.config;

import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="security", name={"require-ssl"}, havingValue="false", matchIfMissing=true)
public class TomcatConfigForHttp {
    private static final Logger log = LoggerFactory.getLogger(TomcatConfigForHttp.class);
    @Value(value="${server.connection-timeout:8000}")
    private Integer timeout;
    @Value(value="${server.tomcat.max-threads:1000}")
    private Integer maxThreads;
    @Value(value="${server.tomcat.max-connections:2000}")
    private Integer maxConnections;
    @Value(value="${server.tomcat.min-spare-threads:80}")
    private Integer minSpareThreads;
    @Value(value="${server.port:8098}")
    private Integer port;

    @Bean
    public ConfigurableServletWebServerFactory createEmbeddedServletContainerFactory() {
        TomcatServletWebServerFactory tomcatFactory = new TomcatServletWebServerFactory();
        tomcatFactory.setPort(this.port.intValue());
        tomcatFactory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new MyTomcatConnectorCustomizer()});
        return tomcatFactory;
    }

    class MyTomcatConnectorCustomizer
    implements TomcatConnectorCustomizer {
        MyTomcatConnectorCustomizer() {
        }

        public void customize(Connector connector) {
            Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
            protocol.setMaxConnections(TomcatConfigForHttp.this.maxConnections.intValue());
            protocol.setMaxThreads(TomcatConfigForHttp.this.maxThreads.intValue());
            protocol.setConnectionTimeout(TomcatConfigForHttp.this.timeout.intValue());
            protocol.setMinSpareThreads(TomcatConfigForHttp.this.minSpareThreads.intValue());
        }
    }
}

