/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.config;

import com.zkteco.zkbiosecurity.core.utils.PropertiesUtil;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class I18nCookieLocaleResolver
implements LocaleResolver {
    private static final String COOKIELOCALERESOLVERSTR = "org.springframework.web.servlet.i18n.CookieLocaleResolver.LOCALE";

    private Locale getDefultLocale() {
        Locale locale = null;
        String lang = PropertiesUtil.getCurrentLanguage();
        if (lang.contains("_")) {
            String[] languageCountry = lang.split("_");
            locale = new Locale(languageCountry[0], languageCountry[1]);
        } else {
            locale = new Locale(lang);
        }
        return locale;
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (COOKIELOCALERESOLVERSTR.equals(cookie.getName())) {
                    String[] languageCountry;
                    String language = cookie.getValue();
                    if (language.contains("_")) {
                        languageCountry = language.split("_");
                        locale = new Locale(languageCountry[0], languageCountry[1]);
                    } else if (language.contains("-")) {
                        languageCountry = language.split("-");
                        locale = new Locale(languageCountry[0], languageCountry[1].toUpperCase());
                    } else {
                        locale = new Locale(language);
                    }
                }
                ++n2;
            }
        }
        return locale == null ? this.getDefultLocale() : locale;
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
    }
}

