/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.aspect;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnExpression(value="${system.open.logAspect:false}")
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="within(com.zkteco.zkbiosecurity..*.service..*.*)||within(com.zkteco.zkbiosecurity..*.dao..*.*)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long time = System.currentTimeMillis() - beginTime;
        if (time > 100L) {
            this.printLog(point, time);
        }
        return result;
    }

    void printLog(ProceedingJoinPoint joinPoint, long time) throws InterruptedException {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String methodName = signature.getName();
        String className = joinPoint.getTarget().getClass().getName();
        Map<String, Object> params = this.getNameAndValue(joinPoint);
        StringBuffer sb = new StringBuffer("");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            sb.append("[name: " + entry.getKey() + " value: " + entry.getValue() + "],");
        }
        log.info("ClassName=" + className + "  MethodName=" + methodName + "  ParamInfo=" + sb.toString() + ",Take time=" + time + " ms");
    }

    Map<String, Object> getNameAndValue(ProceedingJoinPoint joinPoint) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Object[] paramValues = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        if (paramNames != null && paramNames.length > 0) {
            int i = 0;
            while (i < paramNames.length) {
                param.put(paramNames[i], paramValues[i]);
                ++i;
            }
        }
        return param;
    }
}

