/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.aspect;

import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ApiPermissionAspect {
    @Autowired(required=false)
    private BaseLicenseProvider baseLicenseProvider;

    @Around(value="(within(com.zkteco.zkbiosecurity..controller..*) || within(com.zkteco.zkbiosecurity..client..*)) && @annotation(apiPermissions)")
    public Object doInterceptor(ProceedingJoinPoint pjp, ApiPermissions apiPermissions) throws Throwable {
        boolean isPermission = false;
        List<String> activeModuleCodeList = this.baseLicenseProvider.getActiveModuleLIist();
        if (apiPermissions != null) {
            String moduleCode = apiPermissions.moduleCode();
            if ("acc".equalsIgnoreCase(moduleCode) && (activeModuleCodeList.contains("pull") || activeModuleCodeList.contains("push"))) {
                isPermission = true;
            } else if (activeModuleCodeList.contains(moduleCode)) {
                isPermission = true;
            }
        } else {
            isPermission = true;
        }
        if (isPermission) {
            return pjp.proceed();
        }
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        Class<ApiResultMessage> returnType = method.getReturnType();
        if (returnType.isAssignableFrom(ApiResultMessage.class)) {
            ApiResultMessage message = ApiResultMessage.failedMessage(-1);
            message.setMessage(MessageFormat.format(I18nUtil.i18nCode("common_api_nopermission", new Object[0]), I18nUtil.i18nCode(apiPermissions.moduleName(), new Object[0])));
            return message;
        }
        return I18nUtil.i18nMsg(ZKResultMsg.failMsg("common_api_nopermission", I18nUtil.i18nCode(apiPermissions.moduleName(), new Object[0])));
    }
}

