/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsolePlugin;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Messages;

final class ExceptionSafePlugin
extends JConsolePlugin {
    private static boolean ignoreExceptions;
    private final JConsolePlugin plugin;

    public ExceptionSafePlugin(JConsolePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Map<String, JPanel> getTabs() {
        try {
            return this.plugin.getTabs();
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return new HashMap<String, JPanel>();
        }
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        try {
            return this.plugin.newSwingWorker();
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void dispose() {
        try {
            this.plugin.dispose();
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
    }

    public void executeSwingWorker(SwingWorker<?, ?> sw) {
        try {
            sw.execute();
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception e) {
        if (JConsole.isDebug()) {
            System.err.println("Plug-in exception:");
            e.printStackTrace();
        } else if (!ignoreExceptions) {
            this.showExceptionDialog(e);
        }
    }

    private void showExceptionDialog(Exception e) {
        Object[] buttonTexts = new Object[]{Messages.PLUGIN_EXCEPTION_DIALOG_BUTTON_OK, Messages.PLUGIN_EXCEPTION_DIALOG_BUTTON_EXIT, Messages.PLUGIN_EXCEPTION_DIALOG_BUTTON_IGNORE};
        String message = String.format(Messages.PLUGIN_EXCEPTION_DIALOG_MESSAGE, this.plugin.getClass().getSimpleName(), String.valueOf(e.getMessage()));
        int buttonIndex = JOptionPane.showOptionDialog(null, message, Messages.PLUGIN_EXCEPTION_DIALOG_TITLE, 1, 0, null, buttonTexts, buttonTexts[0]);
        if (buttonIndex == 1) {
            System.exit(0);
        }
        ignoreExceptions = buttonIndex == 2;
    }
}

