/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);
    private static final int BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toZip(String src, String target, boolean keepDirStructure) {
        log.debug("Zip File [" + src + "]");
        ZipOutputStream zos = null;
        try {
            FileOutputStream fos = new FileOutputStream(new File(target));
            zos = new ZipOutputStream(fos);
            File sourceFile = new File(src);
            ZipUtils.compress((File)sourceFile, (ZipOutputStream)zos, (String)sourceFile.getName(), (boolean)keepDirStructure);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        ZipUtils.compress((File)file, (ZipOutputStream)zos, (String)(name + "/" + file.getName()), (boolean)true);
                        continue;
                    }
                    ZipUtils.compress((File)file, (ZipOutputStream)zos, (String)file.getName(), (boolean)false);
                }
            }
        }
    }

    public static void unzip(String zip, String out) {
        try {
            Project p = new Project();
            Expand e = new Expand();
            e.setProject(p);
            e.setSrc(new File(zip));
            e.setOverwrite(false);
            e.setDest(new File(out));
            e.setEncoding("gbk");
            e.execute();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

