/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import com.zkteco.tray.annotation.Column;
import com.zkteco.tray.annotation.Condition;
import com.zkteco.tray.annotation.From;
import com.zkteco.tray.annotation.GroupBy;
import com.zkteco.tray.annotation.Limit;
import com.zkteco.tray.annotation.OrderBy;
import com.zkteco.tray.annotation.Where;
import com.zkteco.tray.utils.StrUtil;
import com.zkteco.tray.utils.ZkBeanUtil;
import com.zkteco.tray.vo.BaseItem;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class SQLUtil {
    private static final Pattern prePattern = Pattern.compile(":[\\w]+");
    public static final String DATE_TOCHAR_DAY = "DAY";
    public static final String DATE_TOCHAR_MONTH = "MONTH";
    public static final String DATE_TOCHAR_YEAR = "YEAR";
    public static final String DATE_TOCHAR_HOUR = "HOUR";

    public static String getSqlByItem(BaseItem baseItem) {
        Limit limit;
        StringBuffer sql = new StringBuffer("SELECT ");
        Class<?> itemCls = baseItem.getClass();
        Field[] fields = itemCls.getDeclaredFields();
        boolean equals = baseItem.getEquals();
        StringBuffer condition = new StringBuffer(" ");
        StringBuffer havingCondition = new StringBuffer(" ");
        String orderByCloumn = "";
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            Condition cond = field.getAnnotation(Condition.class);
            if (column == null && cond == null) continue;
            if (column != null) {
                if (StringUtils.isNotBlank((CharSequence)baseItem.getSortName()) && baseItem.getSortName().equals(field.getName())) {
                    orderByCloumn = column.name();
                }
                sql.append(column.name()).append(" AS ").append(field.getName()).append(",");
                String fieldValue = ZkBeanUtil.getProperty((Object)baseItem, (String)field.getName());
                if (column.encryptConverter() && StringUtils.isNotBlank((CharSequence)fieldValue)) {
                    fieldValue = SQLUtil.getFieldValue((String)column.equalTag(), (String)fieldValue);
                }
                if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                    condition.append(SQLUtil.getTagLinkValue((boolean)equals, (String)column.linkTag(), (String)column.equalTag(), (String)column.name(), (Field)field, (String)fieldValue, (boolean)column.toDate(), (boolean)column.encryptConverter()));
                }
            }
            if (cond == null) continue;
            if ("where".equals(cond.coditionType())) {
                SQLUtil.createCodition((Condition)cond, (Field)field, (BaseItem)baseItem, (StringBuffer)condition);
                continue;
            }
            if (!"having".equals(cond.coditionType())) continue;
            SQLUtil.createCodition((Condition)cond, (Field)field, (BaseItem)baseItem, (StringBuffer)havingCondition);
        }
        sql = new StringBuffer(sql.toString().substring(0, sql.length() - 1));
        From from = itemCls.getAnnotation(From.class);
        if (StringUtils.isNotBlank((CharSequence)from.after())) {
            sql.append(" FROM ");
            sql.append(SQLUtil.convertPreSQL((String)from.after(), (BaseItem)baseItem));
        }
        Where where = itemCls.getAnnotation(Where.class);
        sql.append(" WHERE 1=1 ");
        if (where != null) {
            sql.append(where.after());
        }
        sql.append(condition.toString());
        GroupBy groupBy = itemCls.getAnnotation(GroupBy.class);
        if (groupBy != null) {
            sql.append(" GROUP BY ");
            sql.append(groupBy.after());
        }
        if (StringUtils.isNotBlank((CharSequence)havingCondition)) {
            sql.append(" HAVING 1=1 ");
            sql.append(havingCondition);
        }
        OrderBy orderBy = itemCls.getAnnotation(OrderBy.class);
        boolean pageNeedOrder = false;
        if (StringUtils.isNotBlank((CharSequence)orderByCloumn) && StringUtils.isNotBlank((CharSequence)baseItem.getSortOrder())) {
            pageNeedOrder = true;
            sql.append(" ORDER BY ");
            sql.append(orderByCloumn);
            sql.append(" ");
            sql.append(baseItem.getSortOrder());
        }
        if (orderBy != null && !pageNeedOrder) {
            sql.append(" ORDER BY ");
            sql.append(SQLUtil.convertPreSQL((String)orderBy.after(), (BaseItem)baseItem));
        }
        if ((limit = itemCls.getAnnotation(Limit.class)) != null) {
            sql.append(" LIMIT ");
            sql.append(limit.value());
        }
        return sql.toString();
    }

    private static String getFieldValue(String equalTag, String fieldValue) {
        if (StrUtil.toUpperCase((String)equalTag).equals("IN") || StrUtil.toUpperCase((String)equalTag).equals("NOT IN")) {
            return fieldValue;
        }
        return FoldexUtil.encryptByRandomSey((String)fieldValue);
    }

    private static void createCodition(Condition cond, Field field, BaseItem baseItem, StringBuffer condition) {
        String fieldValue = ZkBeanUtil.getProperty((Object)baseItem, (String)field.getName());
        if (cond.encryptConverter() && StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValue = SQLUtil.getFieldValue((String)cond.equalTag(), (String)fieldValue);
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            if (StringUtils.isBlank((CharSequence)cond.equalTag()) && StringUtils.isNotBlank((CharSequence)cond.value())) {
                if (StringUtils.isNotBlank((CharSequence)cond.formatType())) {
                    fieldValue = SQLUtil.formatConditionData((String)fieldValue, (String)cond.formatType());
                }
                String condVal = cond.value();
                String _fieldValue = SQLUtil.conditionValueProcess((Field)field, (String)fieldValue, (boolean)cond.toDate());
                if (condVal.contains("%s")) {
                    condition.append(" ");
                    condition.append(cond.linkTag());
                    condition.append(" ");
                    condition.append(String.format(condVal, _fieldValue));
                } else {
                    condition.append(" ");
                    condition.append(cond.linkTag());
                    condition.append(" ");
                    condition.append(MessageFormat.format(condVal, _fieldValue));
                }
            } else {
                condition.append(SQLUtil.getTagLinkValue((boolean)false, (String)cond.linkTag(), (String)cond.equalTag(), (String)cond.value(), (Field)field, (String)fieldValue, (boolean)cond.toDate(), (boolean)cond.encryptConverter()));
            }
        } else if ("notNull".equals(cond.equalTag())) {
            condition.append(SQLUtil.notNullProcess((String)cond.linkTag(), (String)cond.value(), (Field)field));
        }
    }

    private static String conditionValueProcess(Field field, String fieldValue, boolean toDate) {
        if (SQLUtil.isBaseNumber(field.getType())) {
            return fieldValue;
        }
        if (field.getType() == Character.TYPE || field.getType() == Character.class) {
            return fieldValue;
        }
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            return SQLUtil.booleanProcess((String)fieldValue);
        }
        if (field.getType() == String.class) {
            if (toDate) {
                return SQLUtil.dateValue((String)fieldValue);
            }
            return fieldValue;
        }
        if (field.getType() == Date.class) {
            return SQLUtil.dateValue((String)fieldValue);
        }
        return "";
    }

    public static String dateValue(String fieldValue) {
        return "'" + fieldValue + "'";
    }

    private static String formatConditionData(String fieldValue, String formatType) {
        String rs = fieldValue;
        if ("quote".equals(formatType)) {
            rs = StrUtil.withSingleQuote((String)fieldValue);
        }
        return rs;
    }

    private static String getTagLinkValue(boolean equals, String linkTag, String equalTag, String name, Field field, String fieldValue, boolean toDate, boolean encryptConverter) {
        String tag = equalTag;
        if (equals) {
            tag = "=";
        }
        if ("notNull".equals(equalTag)) {
            return SQLUtil.notNullProcess((String)linkTag, (String)name, (Field)field);
        }
        if (SQLUtil.isBaseNumber(field.getType())) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = "=";
            }
            return " " + linkTag + " " + name + " " + tag + " " + fieldValue;
        }
        if (field.getType() == Character.TYPE || field.getType() == Character.class) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = "=";
            }
            return " " + linkTag + " " + name + " " + tag + " '" + fieldValue + "'";
        }
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            return " " + linkTag + " " + name + " = " + SQLUtil.booleanProcess((String)fieldValue);
        }
        if (field.getType() == String.class) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = name.endsWith(".ID") ? "=" : "LIKE";
            }
            if (StrUtil.toUpperCase((String)tag).equals("LIKE")) {
                return " " + linkTag + " lower(" + name + ") " + tag + " lower('%" + fieldValue + "%')";
            }
            if (StrUtil.toUpperCase((String)tag).equals("LIKEPRE")) {
                return " " + linkTag + " " + name + " " + tag + " '%" + fieldValue + "'";
            }
            if (StrUtil.toUpperCase((String)tag).equals("LIKEPOS")) {
                return " " + linkTag + " " + name + " " + tag + " '" + fieldValue + "%'";
            }
            if (StrUtil.toUpperCase((String)tag).equals("IN") || StrUtil.toUpperCase((String)tag).equals("NOT IN")) {
                return SQLUtil.containInTagProcess((String)linkTag, (String)name, (String)tag, (String)fieldValue, (boolean)encryptConverter);
            }
            if (toDate) {
                return SQLUtil.dateProcess((String)linkTag, (String)name, (String)fieldValue, (String)tag);
            }
            return " " + linkTag + " " + name + " " + tag + " '" + fieldValue + "'";
        }
        if (field.getType() == Date.class) {
            return SQLUtil.dateProcess((String)linkTag, (String)name, (String)fieldValue, (String)tag);
        }
        return "";
    }

    private static String containInTagProcess(String linkTag, String name, String tag, String fieldValue, boolean encryptConverter) {
        String[] array = fieldValue.split(",");
        int length = array.length;
        if (array.length < 1000) {
            return " " + linkTag + " " + name + " " + tag + " (" + SQLUtil.withSingleQuote((String)fieldValue, (boolean)encryptConverter) + ")";
        }
        ArrayList<String> fieldValueList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(array[i]);
            sb.append(",");
            if ((i + 1) % 999 != 0) continue;
            fieldValueList.add(sb.toString());
            sb = new StringBuffer();
        }
        if (sb.length() > 0) {
            fieldValueList.add(sb.toString());
        }
        if ("IN".equals(StrUtil.toUpperCase((String)tag))) {
            sb = new StringBuffer(" " + linkTag + " (1=0 ");
            for (String fl : fieldValueList) {
                sb.append("or (");
                sb.append(name);
                sb.append(" ");
                sb.append(tag);
                sb.append(" (");
                sb.append(SQLUtil.withSingleQuote((String)fl, (boolean)encryptConverter));
                sb.append("))");
            }
            sb.append(")");
        } else if ("NOT IN".equals(StrUtil.toUpperCase((String)tag))) {
            sb = new StringBuffer();
            for (String fl : fieldValueList) {
                sb.append(" ");
                sb.append(linkTag);
                sb.append(" (");
                sb.append(name);
                sb.append(" ");
                sb.append(tag);
                sb.append(" (");
                sb.append(SQLUtil.withSingleQuote((String)fl, (boolean)encryptConverter));
                sb.append("))");
            }
        }
        return sb.toString();
    }

    public static String withSingleQuote(String str, boolean encryptConverter) {
        String[] array;
        StringBuilder sb = new StringBuilder();
        for (String s : array = str.split(",")) {
            if (encryptConverter) {
                s = FoldexUtil.encryptByRandomSey((String)s);
            }
            sb.append("'");
            sb.append(s);
            sb.append("',");
        }
        return StrUtil.removeLastChar((String)sb.toString());
    }

    private static String booleanProcess(String fieldValue) {
        return "true".equals(fieldValue) ? "1" : "0";
    }

    private static String notNullProcess(String linkTag, String name, Field field) {
        if (field.getType() == String.class) {
            return " " + linkTag + " (" + name + " <> '' and " + name + " is not null)";
        }
        return " " + linkTag + " " + name + " is not null";
    }

    private static String dateProcess(String linkTag, String name, String fieldValue, String tag) {
        return " " + linkTag + " " + name + " " + tag + " " + SQLUtil.dateValue((String)fieldValue);
    }

    public String getPageSql(String tableName, String start, String size) {
        return "SELECT * FROM " + tableName + "  limit " + size + " OFFSET " + start;
    }

    public static String dateToChar(String field, String dateType) {
        Assert.notNull((Object)dateType, (String)"dateType must not be null!");
        String dateFormat = "";
        switch (dateType) {
            case "DAY": {
                dateFormat = "yyyy-mm-dd";
                break;
            }
            case "MONTH": {
                dateFormat = "yyyy-mm";
                break;
            }
            case "YEAR": {
                dateFormat = "yyyy";
                break;
            }
            case "HOUR": {
                dateFormat = "yyyy-mm-dd hh24";
                break;
            }
        }
        return "TO_CHAR(" + field + ",'" + dateFormat + "')";
    }

    public static String convertPreSQL(String sql, BaseItem item) {
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            Matcher matcher = prePattern.matcher(sql);
            while (matcher.find()) {
                String fieldName = matcher.group().substring(1);
                try {
                    String fieldValue = ZkBeanUtil.getProperty((Object)item, (String)fieldName);
                    Field field = item.getClass().getDeclaredField(fieldName);
                    if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        if (!SQLUtil.isBaseNumber(field.getType())) {
                            fieldValue = field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? SQLUtil.booleanProcess((String)fieldValue) : (field.getType() == Date.class ? SQLUtil.dateValue((String)fieldValue) : "'" + fieldValue.replaceAll("'", "''") + "'");
                        }
                        sql = sql.replace(":" + fieldName, fieldValue);
                        continue;
                    }
                    sql = sql.replace(":" + fieldName, "''");
                }
                catch (Exception e) {
                    sql = sql.replace(":" + fieldName, "''");
                }
            }
        }
        return sql;
    }

    public static boolean isBaseNumber(Class<?> cls) {
        return cls == Long.TYPE || cls == Long.class || cls == Integer.TYPE || cls == Integer.class || cls == Short.TYPE || cls == Short.class || cls == Double.TYPE || cls == Double.class || cls == Float.TYPE || cls == Float.class || cls == Byte.TYPE || cls == Byte.class;
    }
}

