/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import com.zkteco.tray.security.GrantedAuthorityImpl;
import com.zkteco.tray.security.JwtAuthenticatioToken;
import com.zkteco.tray.utils.SecurityUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;

/*
 * Exception performing whole class analysis ignored.
 */
public class JwtTokenUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String USERNAME = "sub";
    private static final String CREATED = "created";
    private static final String AUTHORITIES = "authorities";
    private static final String SECRET = "abcdefgh";
    private static final long EXPIRE_TIME = 1800000L;

    public static String generateToken(Authentication authentication) {
        HashMap<String, Object> claims = new HashMap<String, Object>(3);
        claims.put("sub", SecurityUtils.getUsername((Authentication)authentication));
        claims.put("created", new Date());
        claims.put("authorities", authentication.getAuthorities());
        return JwtTokenUtils.generateToken(claims);
    }

    private static String generateToken(Map<String, Object> claims) {
        Date expirationDate = new Date(System.currentTimeMillis() + 1800000L);
        return Jwts.builder().setClaims(claims).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, "abcdefgh").compact();
    }

    public static String getUsernameFromToken(String token) {
        String username;
        try {
            Claims claims = JwtTokenUtils.getClaimsFromToken((String)token);
            username = claims.getSubject();
        }
        catch (Exception e) {
            username = null;
        }
        return username;
    }

    public static Authentication getAuthenticationeFromToken(HttpServletRequest request) {
        Authentication authentication = null;
        String token = JwtTokenUtils.getToken((HttpServletRequest)request);
        if (token != null) {
            if (SecurityUtils.getAuthentication() == null) {
                Claims claims = JwtTokenUtils.getClaimsFromToken((String)token);
                if (claims == null) {
                    return null;
                }
                String username = claims.getSubject();
                if (username == null) {
                    return null;
                }
                if (JwtTokenUtils.isTokenExpired((String)token).booleanValue()) {
                    return null;
                }
                Object authors = claims.get((Object)"authorities");
                ArrayList<GrantedAuthorityImpl> authorities = new ArrayList<GrantedAuthorityImpl>();
                if (authors instanceof List) {
                    for (Object object : (List)authors) {
                        authorities.add(new GrantedAuthorityImpl((String)((Map)object).get("authority")));
                    }
                }
                authentication = new JwtAuthenticatioToken((Object)username, null, authorities, token);
            } else if (JwtTokenUtils.validateToken((String)token, (String)SecurityUtils.getUsername()).booleanValue()) {
                authentication = SecurityUtils.getAuthentication();
            }
        }
        return authentication;
    }

    private static Claims getClaimsFromToken(String token) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey("abcdefgh").parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    public static Boolean validateToken(String token, String username) {
        String userName = JwtTokenUtils.getUsernameFromToken((String)token);
        return StringUtils.isNotBlank((CharSequence)userName) && userName.equals(username) && JwtTokenUtils.isTokenExpired((String)token) == false;
    }

    public static String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = JwtTokenUtils.getClaimsFromToken((String)token);
            claims.put((Object)"created", (Object)new Date());
            refreshedToken = JwtTokenUtils.generateToken((Map)claims);
        }
        catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }

    public static Boolean isTokenExpired(String token) {
        try {
            Claims claims = JwtTokenUtils.getClaimsFromToken((String)token);
            Date expiration = claims.getExpiration();
            return expiration.before(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        String tokenHead = "Bearer ";
        if (token == null) {
            token = request.getHeader("token");
        } else if (token.contains(tokenHead)) {
            token = token.substring(tokenHead.length());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("token"))) {
            token = request.getParameter("token");
        }
        if ("".equals(token)) {
            token = null;
        }
        return token;
    }
}

