/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.tray.bean.RecordBean;
import com.zkteco.tray.config.ConfigSource;
import com.zkteco.tray.utils.Base64Utils;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.DBUtils;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.HttpUtils;
import com.zkteco.tray.vo.TrayColumnItem;
import com.zkteco.tray.vo.TrayParamsItem;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);
    private static DriverManagerDataSource dataSource;
    private static JdbcTemplate jdbc;
    private static TrayParamsItem params;

    private static void init() {
        dataSource = new DriverManagerDataSource();
        params = ExecUtils.getNParams((boolean)true);
        dataSource.setUsername(params.getDbUser());
        dataSource.setPassword(params.getDbPwd());
        dataSource.setDriverClassName((String)DBUtils.DRIVERS.get(params.getDbType()));
        String url = (String)DBUtils.URLS.get(params.getDbType());
        url = String.format(url, params.getDbHost(), params.getDbPort(), params.getDbName());
        dataSource.setUrl(url);
        jdbc = new JdbcTemplate((DataSource)dataSource);
    }

    public static String createQuerySql(RecordBean record) {
        StringBuilder sql = new StringBuilder("select * from ");
        sql.append(record.getTable());
        sql.append(" t where 1=1");
        String[] columns = record.getUniqueColumn().split(",");
        JSONObject cont = JSONObject.parseObject((String)Base64Utils.decode((String)record.getContent()));
        for (String column : columns) {
            sql.append(" and t.");
            sql.append(column);
            sql.append("='");
            sql.append(cont.getString(column));
            sql.append("'");
        }
        return sql.toString();
    }

    public static Map<String, Object> findOne(RecordBean record) {
        Map map = null;
        String sql = JdbcUtils.createQuerySql((RecordBean)record);
        List records = jdbc.queryForList(sql);
        if (records != null && !records.isEmpty()) {
            map = (Map)records.get(0);
        }
        return map;
    }

    public static String queryParam(String paramName) {
        String sql = "select param_value from base_sysparam where param_name ='" + paramName + "'";
        List results = jdbc.queryForList(sql);
        if (results != null && !results.isEmpty()) {
            return ((Map)results.get(0)).get("param_value").toString();
        }
        return null;
    }

    public static List<Map<String, Object>> query(String sql, Object ... args) {
        return jdbc.queryForList(sql, args);
    }

    public static String queryUniqueColumn(String tableName, String id) {
        String sql;
        List rows;
        RecordBean table = ConfigSource.getTableByName((String)tableName);
        if (table != null && StringUtils.isNotBlank((CharSequence)table.getUniqueColumn()) && (rows = JdbcUtils.query((String)(sql = "select " + table.getUniqueColumn() + " from " + tableName + " where id='" + id + "'"), (Object[])new Object[0])) != null && !rows.isEmpty()) {
            StringBuilder ret = new StringBuilder();
            for (Map.Entry entry : ((Map)rows.get(0)).entrySet()) {
                ret.append(entry.getValue());
                ret.append(",");
            }
            if (ret.length() > 0) {
                return ret.substring(0, ret.length() - 1);
            }
        }
        return null;
    }

    public static String createAddSql(RecordBean record, List args) {
        if (args == null) {
            args = new ArrayList<Object>();
        }
        JSONObject json = JSONObject.parseObject((String)Base64Utils.decode((String)record.getContent()));
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(record.getTable());
        sql.append(" (");
        int index = 0;
        Set keys = json.keySet();
        for (String key : keys) {
            Object value = json.get((Object)key);
            if (!Objects.nonNull(value)) continue;
            sql.append(key);
            sql.append(",");
            value = JdbcUtils.getFieldValue((Object)value, (TrayColumnItem)ConfigSource.getColumnType((String)record.getTable(), (String)key));
            args.add(value);
            ++index;
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") values (");
        sql.append(StringUtils.repeat((String)"?,", (int)index));
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    public static String createUpdateSql(RecordBean record, List args, String id) {
        String[] uniqueColumns;
        if (args == null) {
            args = new ArrayList<Object>();
        }
        JSONObject json = JSONObject.parseObject((String)Base64Utils.decode((String)record.getContent()));
        StringBuilder sql = new StringBuilder("update ");
        sql.append(record.getTable());
        sql.append(" set ");
        Set keys = json.keySet();
        for (String key : keys) {
            Object value;
            if (StringUtils.isNotBlank((CharSequence)id) && "id".equals(key) || !Objects.nonNull(value = json.get((Object)key))) continue;
            sql.append(key);
            sql.append("=?,");
            value = JdbcUtils.getFieldValue((Object)value, (TrayColumnItem)ConfigSource.getColumnType((String)record.getTable(), (String)key));
            args.add(value);
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where 1=1 ");
        for (String column : uniqueColumns = record.getUniqueColumn().split(",")) {
            sql.append(" and ");
            sql.append(column);
            sql.append("='");
            sql.append(json.getString(column));
            sql.append("'");
        }
        return sql.toString();
    }

    private static Object getFieldValue(Object value, TrayColumnItem column) {
        String columnType = column.getType().toLowerCase();
        if (columnType.contains("time")) {
            value = new Timestamp(CommonUtils.getDateTime((Object)value));
        } else if (columnType.contains("date")) {
            value = new Date(CommonUtils.getDateTime((Object)value));
        }
        return value;
    }

    public static void add(RecordBean record) {
        ArrayList args = new ArrayList();
        String sql = JdbcUtils.createAddSql((RecordBean)record, args);
        jdbc.update(sql, args.toArray());
    }

    public static void update(RecordBean record) {
        ArrayList args = new ArrayList();
        String sql = JdbcUtils.createUpdateSql((RecordBean)record, args, null);
        log.info(sql);
        jdbc.update(sql, args.toArray());
    }

    public static void update(RecordBean record, String id) {
        ArrayList args = new ArrayList();
        String sql = JdbcUtils.createUpdateSql((RecordBean)record, args, (String)id);
        log.info(sql);
        jdbc.update(sql, args.toArray());
    }

    public static void main(String[] args) {
        try {
            System.out.println(HttpUtils.get((String)"http://192.168.200.174:8300"));
        }
        catch (Exception e) {
            System.out.println(1);
        }
    }

    static {
        JdbcUtils.init();
    }
}

