/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import com.zkteco.tray.utils.FileUtils;
import com.zkteco.tray.utils.HttpUtils;
import com.zkteco.tray.utils.ModuleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class JarUtils {
    private static final Pattern HREF = Pattern.compile("href=\".*\"");

    public static Set<String> getPackages(String jar) {
        try {
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> en = jarFile.entries();
            TreeSet<String> packages = new TreeSet<String>();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String name = entry.getName().replaceAll("[\\\\/]+", "/");
                name = name.substring(0, name.lastIndexOf("/"));
                if (!(name = name.replaceAll("/", ".")).startsWith("com.zkteco")) continue;
                packages.add(name);
            }
            return packages;
        }
        catch (Exception e) {
            System.out.println(jar);
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, String> getAllPackages(String dir) {
        List jars;
        File dirFile = new File(dir);
        HashMap<String, String> map = new HashMap<String, String>();
        if (dirFile.isDirectory() && !(jars = FileUtils.findFiles((String)dir, (String)".*\\.jar", null)).isEmpty()) {
            jars.forEach(jar -> {
                Set pkgs = JarUtils.getPackages((String)jar.getPath());
                String moduleName = ModuleUtils.getModuleName((String)jar.getName());
                if (pkgs != null) {
                    for (String pkg : pkgs) {
                        String value = (String)map.get(pkg);
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            if (Arrays.asList(value.split(",")).contains(moduleName)) continue;
                            map.put(pkg, value + "," + moduleName);
                            continue;
                        }
                        map.put(pkg, moduleName);
                    }
                }
            });
        }
        return map;
    }

    public static Map<String, String> getSamePackage(Map<String, String> map) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getValue()) || !entry.getValue().contains(",")) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private static void doCascade(Map<String, Set<String>> map, Set<String> set) {
        int len = set.size();
        String[] ss = set.toArray(new String[0]);
        for (int i = 0; i < ss.length; ++i) {
            set.addAll((Collection<String>)map.get(ss[i]));
        }
        if (len != set.size()) {
            JarUtils.doCascade(map, set);
        }
    }

    private static void doCascade(Map<String, Set<String>> map) {
        for (String key : map.keySet()) {
            JarUtils.doCascade(map, map.get(key));
            map.get(key).remove(key);
        }
    }

    public static Map<String, String> getLinkJar(String dir, String out) {
        Map packages = JarUtils.getAllPackages((String)dir);
        packages = JarUtils.getSamePackage((Map)packages);
        HashMap<String, String> ret = new HashMap<String, String>();
        HashMap<String, TreeSet<String>> tmp = new HashMap<String, TreeSet<String>>();
        for (Map.Entry entry : packages.entrySet()) {
            String[] modules;
            for (String module : modules = ((String)entry.getValue()).split(",")) {
                TreeSet<String> set = (TreeSet<String>)tmp.get(module);
                if (set == null) {
                    set = new TreeSet<String>();
                }
                set.addAll(Arrays.asList(modules));
                set.remove(module);
                tmp.put(module, set);
            }
        }
        JarUtils.doCascade(tmp);
        for (Map.Entry en : tmp.entrySet()) {
            ret.put((String)en.getKey(), StringUtils.join((Iterable)((Iterable)en.getValue()), (String)","));
        }
        JarUtils.print(ret, (String)out);
        return ret;
    }

    public static void print(Map<String, String> map) {
        Set<String> keys = map.keySet();
        keys.stream().sorted().forEach(key -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get(key)))) {
                System.out.println(key + "=" + (String)map.get(key));
            }
        });
    }

    public static void print(Map<String, String> map, String file) {
        StringBuffer out = new StringBuffer();
        Set<String> keys = map.keySet();
        keys.stream().sorted().forEach(key -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get(key)))) {
                out.append((String)key);
                out.append("=");
                out.append((String)map.get(key));
                out.append("\n");
            }
        });
        FileUtils.write((String)file, (String)out.toString(), (boolean)false);
    }

    public static List<String> getAllModule(boolean onlySystem) {
        ArrayList<String> modules = new ArrayList<String>();
        String maven = "http://192.168.200.31:8080/artifactory/repo/com/zkteco/";
        String cont = HttpUtils.get((String)maven);
        Matcher matcher = HREF.matcher(cont);
        while (matcher.find()) {
            String module = matcher.group();
            module = module.split("\"")[1].replaceAll("/", "");
            if (onlySystem) {
                if (!module.matches("zkbiosecurity-.*-system")) continue;
                modules.add(module);
                continue;
            }
            if (!module.startsWith("zkbiosecurity-")) continue;
            modules.add(module);
        }
        return modules;
    }

    public static void loadDependency(String outPath) {
        List modules = JarUtils.getAllModule((boolean)true);
        StringBuilder out = new StringBuilder();
        for (String module : modules) {
            out.append("<dependency>\n");
            out.append("\t<groupId>com.zkteco</groupId>\n");
            out.append("\t<artifactId>");
            out.append(module);
            out.append("</artifactId>\n");
            out.append("\t<version>");
            out.append(JarUtils.getModuleVersion((String)module));
            out.append("</version>\n");
            out.append("</dependency>\n");
        }
        FileUtils.write((String)outPath, (String)out.toString(), (boolean)false);
    }

    public static String getModuleVersion(String module) {
        String version = "";
        String maven = "http://192.168.200.31:8080/artifactory/repo/com/zkteco/" + module;
        String cont = HttpUtils.get((String)maven);
        Matcher matcher = HREF.matcher(cont);
        while (matcher.find()) {
            String v = matcher.group();
            if (!(v = v.split("\"")[1].replaceAll("/", "")).matches("[\\d]+.[\\d]+.[\\d]+.*")) continue;
            version = v;
        }
        return version;
    }

    private static void downloadJar(String module, String out) {
        try {
            String maven = "http://192.168.200.31:8080/artifactory/repo/com/zkteco/";
            String version = JarUtils.getModuleVersion((String)module);
            String url = maven + module + "/" + version + "/" + module + "-" + version + ".jar";
            out = out + "/" + module + "-" + version + ".jar";
            HttpUtils.downloadByGet((String)url, (String)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadAllJar(String out) {
        List modules = JarUtils.getAllModule((boolean)false);
        modules.forEach(module -> JarUtils.downloadJar((String)module, (String)out));
    }
}

