/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import ch.ubique.inieditor.IniEditor;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniUtils {
    private static final Logger log = LoggerFactory.getLogger(IniUtils.class);

    public static String getValue(String path, String section, String propName) {
        String result = "";
        IniEditor ini = new IniEditor();
        try {
            ini.load(new File(path));
            result = ini.get(section, propName);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a");
        }
        return result;
    }

    public static Map<String, String> getSection(String path, String sec) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        IniEditor ini = new IniEditor();
        try {
            ini.load(new File(path));
            List names = ini.optionNames(sec);
            for (String name : names) {
                props.put(name, ini.get(sec, name));
            }
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a");
        }
        return props;
    }

    public static void setValue(String path, String section, String propName, String propValue) {
        IniEditor ini = new IniEditor();
        try {
            ini.load(new File(path));
            if (!ini.hasSection(section)) {
                ini.addSection(section);
            }
            ini.set(section, propName, propValue);
            ini.save(new File(path));
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a");
        }
    }
}

