/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.tray.bean.ZKBusinessException;
import com.zkteco.tray.bean.ZKResultMsg;
import com.zkteco.tray.utils.HttpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final Charset defaultCharset = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8).getCharset();

    private HttpUtils() {
    }

    public static String get(String reqUrl) {
        return HttpUtils.get((String)reqUrl, null);
    }

    public static String get(String reqUrl, Map<String, String> params) {
        Response response = HttpUtils.getAsResponse((String)reqUrl, params, (boolean)true);
        return response.getStringContent();
    }

    public static String post(String reqUrl, String reqData) {
        return HttpUtils.post((String)reqUrl, (String)reqData, (String)"UTF-8");
    }

    public static String post(String reqUrl, String reqData, String encodeCharset) {
        StringEntity entity = null;
        if (null != reqData) {
            try {
                entity = new StringEntity(reqData, encodeCharset);
            }
            catch (ZKBusinessException e) {
                log.error("", (Throwable)e);
                throw new ZKBusinessException((Throwable)e);
            }
        }
        Response response = HttpUtils.postAsResponse((String)reqUrl, entity, (boolean)true);
        return response.getStringContent();
    }

    public static String post(String reqUrl, Map<String, String> params) {
        return HttpUtils.post((String)reqUrl, params, (String)"UTF-8");
    }

    public static String post(String reqUrl, Map<String, String> params, String encodeCharset) {
        HttpEntity entity = null;
        if (null != params) {
            entity = HttpUtils.buildUrlEncodeFormEntity(params, (String)encodeCharset);
        }
        Response response = HttpUtils.postAsResponse((String)reqUrl, (HttpEntity)entity, (boolean)true);
        return response.getStringContent();
    }

    public static Response postAsResponse(String reqUrl, Map<String, String> params) {
        HttpEntity entity = null;
        if (null != params) {
            entity = HttpUtils.buildUrlEncodeFormEntity(params, (String)"UTF-8");
        }
        return HttpUtils.postAsResponse((String)reqUrl, (HttpEntity)entity, (boolean)true);
    }

    public static Response postAsResponse(String reqUrl, Map<String, String> params, String encodeCharset) {
        HttpEntity entity = null;
        if (null != params) {
            entity = HttpUtils.buildUrlEncodeFormEntity(params, (String)encodeCharset);
        }
        return HttpUtils.postAsResponse((String)reqUrl, (HttpEntity)entity, (boolean)true);
    }

    private static HttpEntity buildUrlEncodeFormEntity(Map<String, String> params, String encodeCharset) {
        UrlEncodedFormEntity entity;
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            entity = new UrlEncodedFormEntity(formParams, encodeCharset);
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException((Throwable)e);
        }
        return entity;
    }

    public static Response getAsResponse(String reqUrl, Map<String, String> params, boolean asString) {
        HttpClient httpClient = HttpUtils.getHttpClient((String)reqUrl);
        HttpGet httpReq = new HttpGet(reqUrl);
        if (params != null && !params.isEmpty()) {
            BasicHttpParams httpParams = new BasicHttpParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                httpParams.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            httpReq.setParams((HttpParams)httpParams);
        }
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpReq);
            log.debug("\u8bf7\u6c42\u5730\u5740: " + httpReq.getURI());
            Response retResponse = new Response(asString);
            StatusLine statusLine = response.getStatusLine();
            log.debug("\u54cd\u5e94\u72b6\u6001: " + statusLine);
            retResponse.setStatusLine(statusLine);
            Header[] headers = response.getAllHeaders();
            retResponse.setHeaders(headers);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                Charset respCharset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                retResponse.setCharset(respCharset);
                log.debug("\u54cd\u5e94\u7f16\u7801: " + respCharset);
                if (asString) {
                    String content = EntityUtils.toString((HttpEntity)entity, (Charset)respCharset);
                    retResponse.setStringContent(content);
                    log.debug("\u54cd\u5e94\u5185\u5bb9: " + content);
                } else {
                    retResponse.setByteArrayContent(EntityUtils.toByteArray((HttpEntity)entity));
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            Response response2 = retResponse;
            return response2;
        }
        catch (ClientProtocolException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_protocolError", (Throwable)e);
        }
        catch (ConnectTimeoutException cte) {
            log.error("", (Throwable)cte);
            throw new ZKBusinessException("common_net_timeout", (Throwable)cte);
        }
        catch (SocketTimeoutException ste) {
            log.error("", (Throwable)ste);
            throw new ZKBusinessException("common_net_timeout", (Throwable)ste);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_connError", (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static void write(HttpServletResponse response, Object data) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        ZKResultMsg result = new ZKResultMsg(data);
        String json = JSONObject.toJSONString((Object)result);
        response.getWriter().print(json);
        response.getWriter().flush();
        response.getWriter().close();
    }

    public static Response postAsResponse(String reqUrl, HttpEntity reqEntity, boolean asString) {
        HttpClient httpClient = HttpUtils.getHttpClient((String)reqUrl);
        try {
            Header[] hs;
            HttpPost httpPost = new HttpPost(reqUrl);
            if (reqEntity != null) {
                httpPost.setEntity(reqEntity);
            }
            log.debug("\u8bf7\u6c42\u5730\u5740: " + httpPost.getURI());
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            if ((statusLine.getStatusCode() == 302 || statusLine.getStatusCode() == 301) && (hs = response.getHeaders("Location")).length > 0) {
                Response response2 = HttpUtils.postAsResponse((String)hs[0].getValue(), (HttpEntity)reqEntity, (boolean)asString);
                return response2;
            }
            Response retResponse = new Response(asString);
            log.debug("\u54cd\u5e94\u72b6\u6001: " + statusLine);
            retResponse.setStatusLine(statusLine);
            Header[] headers = response.getAllHeaders();
            retResponse.setHeaders(headers);
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                Charset respCharset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                retResponse.setCharset(respCharset);
                log.debug("\u54cd\u5e94\u7f16\u7801: " + respCharset);
                if (asString) {
                    String content = EntityUtils.toString((HttpEntity)entity, (Charset)respCharset);
                    retResponse.setStringContent(content);
                    log.debug("\u54cd\u5e94\u5185\u5bb9: " + content);
                } else {
                    retResponse.setByteArrayContent(EntityUtils.toByteArray((HttpEntity)entity));
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            Response response3 = retResponse;
            return response3;
        }
        catch (ClientProtocolException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_protocolError", (Throwable)e);
        }
        catch (ConnectTimeoutException cte) {
            log.error("", (Throwable)cte);
            throw new ZKBusinessException("common_net_timeout", (Throwable)cte);
        }
        catch (SocketTimeoutException ste) {
            log.error("", (Throwable)ste);
            throw new ZKBusinessException("common_net_timeout", (Throwable)ste);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new ZKBusinessException("common_net_connError", (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static void downloadByGet(String reqURL, String localFilePath) {
        HttpClient httpClient = HttpUtils.getHttpClient((String)reqURL);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)3600000);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)3600000);
        try {
            HttpGet httpPost = new HttpGet(reqURL);
            log.debug("\u8bf7\u6c42\u5730\u5740: " + httpPost.getURI());
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            log.debug("\u54cd\u5e94\u72b6\u6001: " + statusLine);
            System.out.println(statusLine);
            if (statusLine.getStatusCode() != 200) {
                throw new ZKBusinessException(reqURL + " : " + statusLine.getStatusCode());
            }
            HttpEntity entity = response.getEntity();
            if (null != entity) {
                Charset respCharset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                log.debug("\u54cd\u5e94\u7f16\u7801: " + respCharset);
                InputStream fin = entity.getContent();
                File outFile = new File(localFilePath);
                if (!outFile.exists()) {
                    outFile.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                IOUtils.copy((InputStream)fin, (OutputStream)fos);
                fos.close();
                fin.close();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private static HttpClient getHttpClient(String reqUrl) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.connection.timeout", (Object)600000);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)600000);
        if (reqUrl.startsWith("https")) {
            try {
                1 trustManager = new /* Unavailable Anonymous Inner Class!! */;
                2 hostnameVerifier = new /* Unavailable Anonymous Inner Class!! */;
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{trustManager}, null);
                SSLSocketFactory socketFactory = new SSLSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier);
                httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
                return httpClient;
            }
            catch (Exception e) {
                log.error("create HttpClient with ssl error", (Throwable)e);
                throw new ZKBusinessException((Throwable)e);
            }
        }
        return httpClient;
    }
}

