/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import com.zkteco.tray.bean.ZKBusinessException;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.ImgEncodeUtil;
import com.zkteco.tray.utils.ModuleUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String thumbPath = "thumb";
    public static final String separator = "/";

    public static String path(String ... args) {
        StringBuffer ret = new StringBuffer();
        if (args != null) {
            ret.append(args[0]);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    ret.append("/");
                    ret.append(args[i]);
                }
            }
        }
        return ret.toString().replaceAll("[\\\\/]+", "/");
    }

    public static String createTemp() {
        String tmp = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), System.currentTimeMillis() + ""});
        FileUtils.makeNew((String)tmp);
        return tmp;
    }

    public static boolean renameTo(String src, String dist) {
        File srcFile = new File(src);
        if (srcFile.exists()) {
            ExecUtils.chmod((String)srcFile.getParentFile().getPath(), (String)src, (String)"775");
            boolean ret = srcFile.renameTo(new File(dist));
            if (!ret) {
                log.error("rename failed : " + src);
            }
            return ret;
        }
        return false;
    }

    public static File getFile(File src, File[] files) {
        File dist = null;
        if (files != null && files.length > 0) {
            String moduleName = ModuleUtils.getModuleName((String)src.getName());
            for (File file : files) {
                if (!file.getName().matches(moduleName + "-[\\d]+\\.(.)*")) continue;
                dist = file;
                break;
            }
        }
        return dist;
    }

    public static String read(String fileName) {
        StringBuffer cont = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.UTF_8.name()));
            String line = reader.readLine();
            while (line != null) {
                cont.append(line);
                cont.append("\n");
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            log.error("Read File Error", (Throwable)e);
        }
        return cont.toString().trim();
    }

    public static void write(String filePath, String cont, boolean append) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(filePath), append);
            fos.write(cont.getBytes(StandardCharsets.UTF_8));
            fos.close();
        }
        catch (Exception e) {
            log.error("Write File Error", (Throwable)e);
        }
    }

    public static String getRootPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            path = System.getProperty("user.dir");
        }
        if (FileUtils.exists((String)FileUtils.path((String[])new String[]{path, "service"})) && FileUtils.exists((String)FileUtils.path((String[])new String[]{path, "jre8"}))) {
            return path;
        }
        File parent = new File(path).getParentFile();
        if (parent != null && parent.exists()) {
            return FileUtils.getRootPath((String)parent.getPath());
        }
        return null;
    }

    protected static void copyFile(String oldPath, String newPath) throws IOException {
        int readByte;
        File oldFile = new File(oldPath);
        File file = new File(newPath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        FileInputStream in = new FileInputStream(oldFile);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[0x200000];
        while ((readByte = in.read(buffer)) != -1) {
            out.write(buffer, 0, readByte);
        }
        in.close();
        out.close();
    }

    public static void copy(String src, String dist) {
        File srcFile = new File(src);
        if (srcFile.exists()) {
            try {
                if (srcFile.isDirectory()) {
                    FileUtils.copyDir((String)src, (String)dist);
                } else if (srcFile.isFile()) {
                    FileUtils.copyFile((String)src, (String)dist);
                }
            }
            catch (Exception e) {
                log.error("Copy File Error", (Throwable)e);
            }
        }
    }

    protected static void copyDir(String sourcePath, String newPath) throws IOException {
        File file = new File(sourcePath);
        if (!file.exists()) {
            return;
        }
        String[] filePath = file.list();
        FileUtils.make((String)newPath);
        if (filePath != null) {
            for (String f : filePath) {
                if (FileUtils.isDirectory((String)FileUtils.path((String[])new String[]{sourcePath, f}))) {
                    FileUtils.copyDir((String)FileUtils.path((String[])new String[]{sourcePath, f}), (String)FileUtils.path((String[])new String[]{newPath, f}));
                }
                if (!FileUtils.isFile((String)FileUtils.path((String[])new String[]{sourcePath, f}))) continue;
                FileUtils.copyFile((String)FileUtils.path((String[])new String[]{sourcePath, f}), (String)FileUtils.path((String[])new String[]{newPath, f}));
            }
        }
    }

    public static boolean isDirectory(String dir) {
        return new File(dir).isDirectory();
    }

    public static boolean isFile(String dir) {
        return new File(dir).isFile();
    }

    public static String findRootByFiles(File root, String ... files) {
        if (root.isDirectory() && files != null && files.length > 0) {
            boolean found = true;
            for (String file : files) {
                if (FileUtils.exists((String)FileUtils.path((String[])new String[]{root.getPath(), file}))) continue;
                found = false;
                break;
            }
            if (found) {
                return root.getPath();
            }
            File[] list = root.listFiles();
            if (list != null) {
                for (File f : list) {
                    String ret = FileUtils.findRootByFiles((File)f, (String[])files);
                    if (!StringUtils.isNotBlank((CharSequence)ret)) continue;
                    return ret;
                }
            }
        }
        return null;
    }

    public static void make(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void makeNew(String path) {
        File file = new File(path);
        if (file.exists()) {
            FileUtils.deleteFile((String)path);
        }
        file.mkdirs();
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    FileUtils.deleteFile((String)f.getPath());
                }
            }
            file.delete();
        }
    }

    public static void deleteFile(String fileName, String filter) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        if (file.isFile() && file.getName().matches(filter)) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    FileUtils.deleteFile((String)f.getPath(), (String)filter);
                }
            }
            if (file.getName().matches(filter)) {
                file.delete();
            }
        }
    }

    public static void saveFile(String file, InputStream is) {
        log.info("save file: " + file);
        byte[] b = new byte[1024];
        try {
            int len;
            FileOutputStream fos = new FileOutputStream(new File(file));
            while ((len = is.read(b)) != -1) {
                fos.write(b, 0, len);
            }
            fos.close();
            is.close();
        }
        catch (Exception e) {
            log.error("save file error", (Throwable)e);
        }
    }

    public static void createThumbPic(File originalFile, String filePath, String fileName) {
        if (fileName.toLowerCase().matches(".*?(jpg|jpeg|png|bmp|gif)")) {
            String fullThumbPath = filePath + "/" + "thumb";
            File thumbFile = new File(new File(fullThumbPath), fileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".jpg");
            if (!thumbFile.getParentFile().exists()) {
                thumbFile.getParentFile().mkdirs();
            }
            if (thumbFile.exists()) {
                thumbFile.delete();
            }
            ImgEncodeUtil.createZoomImage((File)originalFile, (File)thumbFile);
        }
    }

    public static void saveFile(String filePath, String fileName, String base64ImgStr, boolean thumbPic) {
        OutputStream out = null;
        try {
            File file = new File(new File(filePath), fileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            out.write(Base64.getDecoder().decode(base64ImgStr));
            out.flush();
            out.close();
            if (thumbPic) {
                FileUtils.createThumbPic((File)file, (String)filePath, (String)fileName);
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException("Save File Error :" + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    public static boolean exists(String file) {
        return new File(file).exists();
    }

    public static List<File> findFiles(String root, String regex, List<File> files) {
        File[] children;
        File rootFile;
        if (files == null) {
            files = new ArrayList<File>();
        }
        if ((rootFile = new File(root)).isFile() && rootFile.getName().matches(regex)) {
            files.add(rootFile);
        } else if (rootFile.isDirectory() && (children = rootFile.listFiles()) != null) {
            for (File f : children) {
                FileUtils.findFiles((String)f.getPath(), (String)regex, files);
            }
        }
        return files;
    }

    public static String getMd5(String path) {
        String md5 = null;
        try (FileInputStream inputStream = new FileInputStream(new File(path));){
            md5 = DigestUtils.md5DigestAsHex((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error("get {} md5 error, {}", (Object)path, (Object)e.getMessage());
        }
        return md5;
    }

    public static void setUpdateTime(String filePath, long mill) {
        File file = new File(filePath);
        if (file.exists()) {
            file.setLastModified(mill);
        }
    }
}

