/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import com.alibaba.fastjson.JSON;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.vo.TrayColumnItem;
import com.zkteco.tray.vo.TrayParamsItem;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);
    private static final String SQL = "SELECT * FROM ";
    public static Map<String, String> URLS;
    public static Map<String, String> DRIVERS;
    public static Map<String, String> DIALECTS;

    private static void init() {
        URLS = new HashMap();
        URLS.put("postgre", "jdbc:postgresql://%s:%s/%s");
        URLS.put("oracle", "jdbc:oracle:thin:@%s:%s:%s");
        URLS.put("mssql", "jdbc:sqlserver://%s:%s;DatabaseName=%s;useLOBs=false");
        URLS.put("dm", "jdbc:dm://%s:%s?schema=%s");
        DRIVERS = new HashMap();
        DRIVERS.put("postgre", "org.postgresql.Driver");
        DRIVERS.put("oracle", "oracle.jdbc.OracleDriver");
        DRIVERS.put("mssql", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        DRIVERS.put("dm", "dm.jdbc.driver.DmDriver");
        DIALECTS = new HashMap();
        DIALECTS.put("postgre", "com.zkteco.tray.config.PostgreDialect");
        DIALECTS.put("mssql", "com.zkteco.tray.config.SqlServerDialect");
    }

    public static Connection getConnection(TrayParamsItem params) {
        if (params == null) {
            params = ExecUtils.getNParams((boolean)true);
        }
        Connection con = null;
        try {
            String pwd = ExecUtils.getDecryptPwd((TrayParamsItem)params, (String)params.getDbPwd());
            if ("postgre".equals(params.getDbType())) {
                Class.forName("org.postgresql.Driver").newInstance();
                String url = "jdbc:postgresql://" + params.getDbHost() + ":" + params.getDbPort() + "/" + params.getDbName();
                con = DriverManager.getConnection(url, params.getDbUser(), pwd);
            } else if ("oracle".equals(params.getDbType())) {
                Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
                String url = "jdbc:oracle:thin:@" + params.getDbHost() + ":" + params.getDbPort() + ":" + params.getDbName();
                con = DriverManager.getConnection(url, params.getDbUser(), pwd);
            } else if ("mssql".equals(params.getDbType())) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
                String url = "jdbc:sqlserver://" + params.getDbHost() + ":" + params.getDbPort() + ";DatabaseName=" + params.getDbName();
                con = DriverManager.getConnection(url, params.getDbUser(), pwd);
            } else if ("dm".equals(params.getDbType())) {
                Class.forName("dm.jdbc.driver.DmDriver").newInstance();
                String url = "jdbc:dm://" + params.getDbHost() + ":" + params.getDbPort() + "?schema=" + params.getDbName();
                con = DriverManager.getConnection(url, params.getDbUser(), pwd);
            }
        }
        catch (Exception e) {
            log.error(JSON.toJSONString((Object)params), (Throwable)e);
        }
        return con;
    }

    public static boolean testConnect(TrayParamsItem params) {
        Connection con = DBUtils.getConnection((TrayParamsItem)params);
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTableNames(Connection conn) {
        ArrayList<String> tableNames = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData db = conn.getMetaData();
            rs = db.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                tableNames.add(rs.getString(3));
            }
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                conn.close();
            }
            catch (SQLException e) {
                log.error("", (Throwable)e);
            }
        }
        return tableNames;
    }

    public static List<String> getTableNames(TrayParamsItem item) {
        Connection conn = DBUtils.getConnection((TrayParamsItem)item);
        return DBUtils.getTableNames((Connection)conn);
    }

    public static List<String> getColumnNames(TrayParamsItem item, String tableName) {
        Connection conn = DBUtils.getConnection((TrayParamsItem)item);
        return DBUtils.getColumnNames((Connection)conn, (String)tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumnNames(Connection conn, String tableName) {
        ArrayList<String> columnNames = new ArrayList<String>();
        PreparedStatement pStemt = null;
        String tableSql = "SELECT * FROM " + tableName;
        try {
            pStemt = conn.prepareStatement(tableSql);
            ResultSetMetaData rsmd = pStemt.getMetaData();
            int size = rsmd.getColumnCount();
            for (int i = 0; i < size; ++i) {
                columnNames.add(rsmd.getColumnName(i + 1));
            }
        }
        catch (SQLException e) {
            log.error(tableName, (Throwable)e);
        }
        finally {
            if (pStemt != null) {
                try {
                    pStemt.close();
                    conn.close();
                }
                catch (SQLException e) {
                    log.error(tableName, (Throwable)e);
                }
            }
        }
        return columnNames;
    }

    public static Map<String, TrayColumnItem> getColumnTypes(String tableName) {
        TrayParamsItem params = ExecUtils.getNParams((boolean)true);
        return DBUtils.getColumnTypes((TrayParamsItem)params, (String)tableName);
    }

    public static Map<String, TrayColumnItem> getColumnTypes(TrayParamsItem params, String tableName) {
        Connection conn = DBUtils.getConnection((TrayParamsItem)params);
        return DBUtils.getColumnTypes((Connection)conn, (String)tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, TrayColumnItem> getColumnTypes(Connection conn, String tableName) {
        HashMap<String, TrayColumnItem> columnTypes = new HashMap<String, TrayColumnItem>();
        PreparedStatement pStemt = null;
        String tableSql = "SELECT * FROM " + tableName;
        try {
            pStemt = conn.prepareStatement(tableSql);
            ResultSetMetaData rsmd = pStemt.getMetaData();
            int size = rsmd.getColumnCount();
            for (int i = 0; i < size; ++i) {
                TrayColumnItem column = new TrayColumnItem();
                column.setName(rsmd.getColumnName(i + 1).toLowerCase());
                column.setLabel(rsmd.getColumnLabel(i + 1));
                column.setType(rsmd.getColumnTypeName(i + 1));
                column.setSize(rsmd.getColumnDisplaySize(i + 1));
                columnTypes.put(column.getName(), column);
            }
        }
        catch (SQLException e) {
            log.error(tableName, (Throwable)e);
        }
        finally {
            if (pStemt != null) {
                try {
                    pStemt.close();
                    conn.close();
                }
                catch (SQLException e) {
                    log.error(tableName, (Throwable)e);
                }
            }
        }
        return columnTypes;
    }

    public static void main(String[] args) {
    }

    static {
        DBUtils.init();
    }
}

