/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.utils;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);

    public static boolean isWindow() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static String md5(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes(StandardCharsets.UTF_8.name()));
        }
        catch (NoSuchAlgorithmException e) {
            log.debug("NoSuchAlgorithmException caught!");
            log.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        StringBuffer md5StrBuff = new StringBuffer();
        if (messageDigest != null) {
            byte[] byteArray = messageDigest.digest();
            for (int i = 0; i < byteArray.length; ++i) {
                if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
        }
        return md5StrBuff.toString();
    }

    public static String getCurrentDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public static Long getDateTimeByFormat(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date d = sdf.parse(date);
        return d.getTime();
    }

    public static Long getDateTime(Object value) {
        if (value instanceof String) {
            try {
                if (value.toString().matches("[\\d]{13,}")) {
                    return Long.parseLong(value.toString());
                }
                if (value.toString().matches("[\\d]{4}-[\\d]{2}-[\\d]{2}")) {
                    return CommonUtils.getDateTimeByFormat((String)value.toString(), (String)"yyyy-MM-dd");
                }
                if (value.toString().matches("[\\d]{4}-[\\d]{2}-[\\d]{2} [\\d]{2}:[\\d]{2}:[\\d]{2}")) {
                    return CommonUtils.getDateTimeByFormat((String)value.toString(), (String)"yyyy-MM-dd HH:mm:ss");
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                e.printStackTrace();
            }
        } else {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Timestamp) {
                return ((Timestamp)value).getTime();
            }
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
        }
        return 0L;
    }

    public static String getLocalhost() {
        try {
            Enumeration<NetworkInterface> allNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetworkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = allNetworkInterfaces.nextElement();
                Enumeration<InetAddress> allInetAddress = networkInterface.getInetAddresses();
                while (allInetAddress.hasMoreElements()) {
                    InetAddress ipAddress = allInetAddress.nextElement();
                    if (!(ipAddress instanceof Inet4Address) || "127.0.0.1".equals(ipAddress.getHostAddress())) continue;
                    return ipAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            log.error("", (Throwable)e);
        }
        return "127.0.0.1";
    }

    public static void sleep(long mill) {
        try {
            Thread.sleep(mill);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static void catchFunction(Consumer action, Consumer errorAction) {
        int runCount = 0;
        while (true) {
            try {
                action.accept(null);
            }
            catch (Exception e) {
                CommonUtils.sleep((long)1000L);
                log.error("", (Throwable)e);
                if (++runCount <= 100) continue;
                errorAction.accept(null);
            }
            break;
        }
    }

    public static void catchFunction(Consumer action) {
        CommonUtils.catchFunction((Consumer)action, args -> {});
    }
}

