/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.task;

import com.zkteco.tray.service.TrayParamService;
import com.zkteco.tray.service.TraySyncService;
import com.zkteco.tray.utils.JdbcUtils;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
@EnableScheduling
public class TraySyncResolverTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(TraySyncResolverTask.class);
    @Autowired
    private TrayParamService trayParamService;
    @Autowired
    private TraySyncService traySyncService;
    public static boolean resolving = true;
    private int count = 0;

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(() -> {
            try {
                boolean result;
                this.count += 10;
                if (this.count == 300) {
                    resolving = true;
                    this.count = 0;
                }
                if (!resolving) {
                    return;
                }
                this.loadRandomSey();
                log.info("Resolve Sync Record : " + LocalDateTime.now().toLocalTime());
                while (result = this.traySyncService.resolverRecord()) {
                }
                resolving = false;
                this.traySyncService.flush();
            }
            catch (Exception e) {
                log.error("TraySyncResolverTask", (Throwable)e);
            }
        }, triggerContext -> {
            String cron = this.trayParamService.getValueByName("tray.sync.time", "1");
            return new CronTrigger("0/10 * * * * ?").nextExecutionTime(triggerContext);
        });
    }

    private void loadRandomSey() {
        String val = JdbcUtils.queryParam((String)"system.security.random");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            System.setProperty("system.security.randomsey", val);
        }
    }

    private String getCron(String minute) {
        int min = Integer.parseInt(minute);
        String cron = min < 60 ? String.format("0 0/%s * * * ?", min) : String.format("0 %s 0/%s * * ?", min % 60, min / 60);
        return cron;
    }
}

