/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.task;

import com.zkteco.tray.service.TrayParamService;
import com.zkteco.tray.service.TraySyncService;
import com.zkteco.tray.utils.JdbcUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
@EnableScheduling
public class TraySyncCheckTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(TraySyncCheckTask.class);
    public static boolean IS_CHECKING = false;
    @Autowired
    private TrayParamService trayParamService;
    @Autowired
    private TraySyncService traySyncService;

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(() -> {
            try {
                this.loadRandomSey();
                this.traySyncService.check();
            }
            catch (Exception e) {
                log.error("TraySyncCheckTask Error", (Throwable)e);
            }
        }, triggerContext -> {
            String cron = this.trayParamService.getValueByName("tray.sync.check.time", "5");
            return new CronTrigger(this.getCron(cron)).nextExecutionTime(triggerContext);
        });
    }

    private void loadRandomSey() {
        String val = JdbcUtils.queryParam((String)"system.security.random");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            System.setProperty("system.security.randomsey", val);
        }
    }

    private String getCron(String minute) {
        int min = Integer.parseInt(minute);
        String cron = min < 60 ? String.format("0 0/%s * * * ?", min) : String.format("0 %s 0/%s * * ?", min % 60, min / 60);
        return cron;
    }
}

