/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.task;

import com.zkteco.tray.service.TrayLocalRecordService;
import com.zkteco.tray.service.TrayRecordService;
import com.zkteco.tray.service.TrayServerService;
import com.zkteco.tray.service.TraySyncService;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.vo.TrayLocalRecordItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
@EnableScheduling
public class TraySenderTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(TraySenderTask.class);
    @Autowired
    private TraySyncService traySyncService;
    @Autowired
    private TrayServerService trayServerService;
    @Autowired
    private TrayRecordService trayRecordService;
    @Autowired
    private TrayLocalRecordService trayLocalRecordService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    private static Map<String, List<TrayLocalRecordItem>> queue;
    private static int count;

    public static void remove(String remoteHost) {
        if (queue != null && queue.containsKey(remoteHost)) {
            queue.remove(remoteHost);
        }
    }

    private void loadRecord() {
        if (queue == null) {
            queue = new HashMap();
        }
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)"SendEmpty::all");
        CommonUtils.catchFunction(args -> this.traySyncService.resetRecordStatus());
        TrayLocalRecordItem condition = new TrayLocalRecordItem();
        condition.setStatus("0");
        List items = this.trayLocalRecordService.list(condition);
        log.info("Send items:" + (items != null ? Integer.valueOf(items.size()) : "0"));
        if (items != null && !items.isEmpty()) {
            items.forEach(item -> {
                ArrayList<TrayLocalRecordItem> srv = (ArrayList<TrayLocalRecordItem>)queue.get(item.getRemoteHost());
                if (srv == null) {
                    srv = new ArrayList<TrayLocalRecordItem>();
                }
                srv.add((TrayLocalRecordItem)item);
                queue.put(item.getRemoteHost(), srv);
            });
        }
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(() -> {
            try {
                if (queue == null) {
                    this.loadRecord();
                }
                boolean found = false;
                int imgCount = 0;
                for (Map.Entry entry : queue.entrySet()) {
                    if (entry.getValue() == null || ((List)entry.getValue()).isEmpty() || this.trayServerService.isStop((String)entry.getKey())) continue;
                    this.trayServerService.updateStatus((String)entry.getKey(), "syncing", "");
                    ArrayList<TrayLocalRecordItem> items = new ArrayList<TrayLocalRecordItem>();
                    for (int i = 0; i < 100 && i < ((List)entry.getValue()).size(); ++i) {
                        try {
                            TrayLocalRecordItem item = (TrayLocalRecordItem)((List)entry.getValue()).remove(i);
                            this.trayLocalRecordService.updateTime(item.getId());
                            item.setDifTime(Long.valueOf(System.currentTimeMillis()));
                            items.add(item);
                            if (!"img".equals(item.getType()) || ++imgCount < 20) continue;
                            break;
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                    }
                    imgCount = 0;
                    this.traySyncService.sendToRemoteServer((String)entry.getKey(), items);
                    if (((List)entry.getValue()).isEmpty()) {
                        this.trayServerService.updateStatus((String)entry.getKey(), "wait", "");
                    }
                    found = true;
                    count = 0;
                    break;
                }
                if (!found && (count += 5) == 30) {
                    count = 0;
                    this.loadRecord();
                }
            }
            catch (Exception e) {
                log.error("TraySenderTask Error", (Throwable)e);
            }
        }, triggerContext -> new CronTrigger("0/5 * * * * ?").nextExecutionTime(triggerContext));
    }

    static {
        count = 0;
    }
}

