/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.zkteco.tray.bean.FileType;
import com.zkteco.tray.bean.ImageBean;
import com.zkteco.tray.bean.RecordBean;
import com.zkteco.tray.bean.ZKResultMsg;
import com.zkteco.tray.config.ConfigSource;
import com.zkteco.tray.service.TrayLocalRecordService;
import com.zkteco.tray.service.TrayRecordService;
import com.zkteco.tray.service.TrayServerService;
import com.zkteco.tray.service.TraySyncService;
import com.zkteco.tray.task.TraySyncCheckTask;
import com.zkteco.tray.task.TraySyncResolverTask;
import com.zkteco.tray.utils.Base64Utils;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.FileEncryptUtil;
import com.zkteco.tray.utils.FileUtils;
import com.zkteco.tray.utils.HttpUtils;
import com.zkteco.tray.utils.JdbcUtils;
import com.zkteco.tray.utils.ModelUtils;
import com.zkteco.tray.vo.TrayLocalRecordItem;
import com.zkteco.tray.vo.TrayRecordItem;
import com.zkteco.tray.vo.TrayServerItem;
import com.zkteco.zkbiosecurity.guard.foldex.constant.EncryptEnum;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.io.File;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class TraySyncServiceImpl
implements TraySyncService {
    private static final Logger log = LoggerFactory.getLogger(TraySyncServiceImpl.class);
    @Autowired
    private TrayRecordService trayRecordService;
    @Autowired
    private TrayLocalRecordService trayLocalRecordService;
    @Autowired
    private TrayServerService trayServerService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired(required=false)
    private JdbcTemplate jdbcTemplate;

    private boolean checkAllTable(TrayServerItem server) {
        boolean result = true;
        List tables = ConfigSource.getTables();
        TrayServerItem local = this.trayServerService.getLocalServer();
        for (RecordBean table : tables) {
            try {
                List items;
                if (!ConfigSource.isServerNormal((String)server.getHost())) {
                    result = false;
                    break;
                }
                String sql = "select * from " + table.getTable();
                if (Objects.nonNull(ConfigSource.getSyncTime((TrayServerItem)server))) {
                    sql = sql + " t where t.UPDATE_TIME >= ? order by t.create_time";
                    items = JdbcUtils.query((String)sql, (Object[])new Object[]{new Timestamp(ConfigSource.getSyncTime((TrayServerItem)server).getTime())});
                } else {
                    sql = sql + " t order by t.create_time";
                    items = JdbcUtils.query((String)sql, (Object[])new Object[0]);
                }
                if (items == null || items.size() <= 0) continue;
                log.info("check " + table.getTable() + " items: " + items.size());
                this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("Check::" + server.getHost()));
                ArrayList tempItems = new ArrayList();
                List records = null;
                for (int i = 0; i < items.size(); ++i) {
                    if (tempItems.size() >= 100) {
                        records = this.convert(tempItems, table);
                        this.addRecords(local.getHost(), server.getHost(), records);
                        tempItems = new ArrayList();
                        System.gc();
                    }
                    tempItems.add(items.get(i));
                }
                if (tempItems.size() <= 0) continue;
                records = this.convert(tempItems, table);
                this.addRecords(local.getHost(), server.getHost(), records);
            }
            catch (Exception e) {
                log.error("Check Table Error:" + table.getTable());
            }
        }
        return result;
    }

    private void sendToRemoteServer(String server, List<TrayLocalRecordItem> items, boolean isFromCache) {
        if (!items.isEmpty()) {
            log.info("Send to " + server);
            this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("Send::" + server));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("cont", Base64Utils.encode((String)JSON.toJSONString(items)));
            try {
                String resp = HttpUtils.post((String)(server + "/receive"), params);
                if (JSONValidator.from((String)resp).validate()) {
                    JSONObject res = JSONObject.parseObject((String)resp);
                    if (!StringUtils.equalsIgnoreCase((CharSequence)res.getString("ret"), (CharSequence)ZKResultMsg.RET_OK)) {
                        log.error("Sync Data Send Failed: " + ((String)params.get("cont")).length());
                        this.saveLocalToDb(items, isFromCache);
                        this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("SendError::" + server));
                    } else {
                        log.info("Success To Send " + server);
                        String ids = items.stream().map(TrayLocalRecordItem::getId).distinct().collect(Collectors.joining(","));
                        CommonUtils.catchFunction(arg0 -> this.trayLocalRecordService.delete(ids));
                    }
                } else {
                    this.saveLocalToDb(items, isFromCache);
                    this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("SendError::" + server));
                    log.error("Sync Data Send Failed: " + ((String)params.get("cont")).length());
                }
            }
            catch (Exception e) {
                this.saveLocalToDb(items, isFromCache);
                this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("SendError::" + server));
                log.error("Sync Data Send Failed: " + ((String)params.get("cont")).length(), (Throwable)e);
            }
        }
    }

    public void sendToRemoteServer(String server, List<TrayLocalRecordItem> items) {
        this.sendToRemoteServer(server, items, true);
    }

    public void flush() {
        try {
            if (this.jdbcTemplate != null) {
                this.jdbcTemplate.execute("vacuum");
            }
        }
        catch (Exception e) {
            log.error("SQLite Flush Error", (Throwable)e);
        }
    }

    private boolean checkRecord(TrayServerItem server) {
        try {
            Date syncTime = new Date();
            this.resolveLocalTemp("local");
            boolean result = this.checkAllTable(server);
            this.checkImageFile(server);
            if (!ConfigSource.isServerNormal((String)server.getHost())) {
                return false;
            }
            if (result) {
                server.setSyncTime(syncTime);
                ConfigSource.addServer((TrayServerItem)server);
                this.trayServerService.updateSyncTime(server.getId(), syncTime);
            }
        }
        catch (Exception e) {
            log.error("Check Sync Error", (Throwable)e);
        }
        return false;
    }

    public void resetRecordStatus() {
        try {
            String sql = "update tray_local_record set status='0' where 1=1 and status='1'";
            if (this.jdbcTemplate != null) {
                this.jdbcTemplate.update(sql);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void checkImageFile(TrayServerItem server) {
        String root = FileUtils.getRootPath(null);
        if (StringUtils.isNotBlank((CharSequence)root)) {
            ArrayList files = new ArrayList();
            TrayServerItem local = this.trayServerService.getLocalServer();
            ConfigSource.getDirs().forEach(dir -> {
                dir = FileUtils.path((String[])new String[]{root, dir});
                this.findImageFile(server, dir, files);
                ArrayList tempFiles = new ArrayList();
                List items = null;
                for (int i = 0; i < files.size(); ++i) {
                    if (tempFiles.size() > 100) {
                        items = this.convertImageFile(tempFiles);
                        this.addRecords(local.getHost(), server.getHost(), items);
                        tempFiles = new ArrayList();
                    }
                    tempFiles.add(files.get(i));
                }
                if (tempFiles.size() > 0) {
                    items = this.convertImageFile(tempFiles);
                    this.addRecords(local.getHost(), server.getHost(), items);
                }
            });
        }
    }

    private void saveLocalToDb(List<TrayLocalRecordItem> items, boolean isFromCache) {
        if (isFromCache) {
            this.resetRecordStatus();
        } else {
            CommonUtils.catchFunction(arg0 -> this.trayLocalRecordService.saveAll(items), arg1 -> {
                this.saveLocalTemp((Object)items, "local");
                this.resolveLocalTemp("local");
            });
        }
    }

    private void addRecords(String local, String server, List<TrayLocalRecordItem> items) {
        if (items != null && !items.isEmpty()) {
            for (TrayLocalRecordItem item : items) {
                if (!ConfigSource.isServerNormal((String)server)) {
                    return;
                }
                item.setHost(local);
                item.setStatus("0");
                item.setRemoteHost(server);
            }
            this.sendToRemoteServer(server, items, false);
            CommonUtils.sleep((long)200L);
        }
    }

    private void resolveLocalTemp(String type) {
        String data = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), "data", type});
        if (FileUtils.exists((String)data)) {
            File[] files;
            File dir = new File(data);
            for (File file : files = dir.listFiles()) {
                String cont;
                if (!file.getName().endsWith("tmp") || !StringUtils.isNotBlank((CharSequence)(cont = FileUtils.read((String)file.getPath())))) continue;
                try {
                    List items;
                    cont = Base64Utils.decode((String)cont);
                    if ("local".equals(type)) {
                        items = JSONObject.parseArray((String)cont, TrayLocalRecordItem.class);
                        this.trayLocalRecordService.saveAll(items);
                    } else if ("remote".equals(type)) {
                        items = JSONObject.parseArray((String)cont, TrayRecordItem.class);
                        this.trayRecordService.saveAll(items);
                    }
                    file.delete();
                }
                catch (Exception e) {
                    log.error("resolve temp error", (Throwable)e);
                }
            }
        }
    }

    private void saveLocalTemp(Object obj, String type) {
        ArrayList list = obj;
        if (!(obj instanceof Iterable)) {
            ArrayList items = new ArrayList();
            items.add(obj);
            list = items;
        }
        String data = FileUtils.path((String[])new String[]{System.getProperty("user.dir"), "data", type});
        FileUtils.make((String)data);
        String cont = Base64Utils.encode((String)JSON.toJSONString(list));
        String filePath = FileUtils.path((String[])new String[]{data, System.currentTimeMillis() + "" + Math.round(Math.random() * 1000.0) + ".tmp"});
        FileUtils.write((String)filePath, (String)cont, (boolean)false);
    }

    private List<TrayLocalRecordItem> convertImageFile(List<File> files) {
        ArrayList<TrayLocalRecordItem> items = new ArrayList<TrayLocalRecordItem>();
        String batch = UUID.randomUUID().toString().replaceAll("-", "");
        String root = FileUtils.path((String[])new String[]{FileUtils.getRootPath(null)});
        files.forEach(file -> {
            ImageBean image = new ImageBean();
            image.setOpBatch(batch);
            image.setPath(FileUtils.path((String[])new String[]{file.getPath()}).substring(root.length()));
            image.setUpdateTime(Long.valueOf(file.lastModified()));
            image.setContent(FileEncryptUtil.getDecryptFileBase64((String)file.getPath()));
            TrayLocalRecordItem item = new TrayLocalRecordItem();
            item.setOpBatch(batch);
            item.setType("img");
            item.setContent(Base64Utils.encode((String)JSONObject.toJSONString((Object)image)));
            item.setComment(image.getPath());
            items.add(item);
        });
        return items;
    }

    private List<File> findImageFile(TrayServerItem server, String dir, List<File> files) {
        File[] subFiles;
        File dirFile;
        if (files == null) {
            files = new ArrayList<File>();
        }
        if ((dirFile = new File(dir)).isDirectory() && (subFiles = dirFile.listFiles()) != null && subFiles.length > 0) {
            for (File file : subFiles) {
                if (file.isFile()) {
                    if (!this.checkImageType(file, server)) continue;
                    if (Objects.isNull(ConfigSource.getSyncTime((TrayServerItem)server))) {
                        files.add(file);
                        ConfigSource.signFile((String)file.getPath(), (String)server.getHost());
                        continue;
                    }
                    if (file.lastModified() <= ConfigSource.getSyncTime((TrayServerItem)server).getTime()) continue;
                    files.add(file);
                    ConfigSource.signFile((String)file.getPath(), (String)server.getHost());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findImageFile(server, file.getPath(), files);
            }
        }
        return files;
    }

    private boolean checkImageType(File imageFile, TrayServerItem server) {
        return imageFile.getName().toLowerCase().endsWith(FileType.JPEG.getExt().toLowerCase()) && !ConfigSource.isFileSync((File)imageFile, (String)server.getHost());
    }

    public boolean check() {
        if (TraySyncCheckTask.IS_CHECKING) {
            return false;
        }
        TraySyncCheckTask.IS_CHECKING = true;
        log.info("Check Sync Record : " + LocalDateTime.now().toLocalTime());
        try {
            List servers = this.trayServerService.getServerExceptLocal();
            if (servers == null || servers.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            servers.forEach(server -> {
                if ("stop".equals(server.getStatus())) {
                    return;
                }
                if (!ConfigSource.isServerNormal((String)server.getHost())) {
                    return;
                }
                ConfigSource.addServer((TrayServerItem)server);
                log.info("Check " + server.getHost());
                this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("Check::" + server.getId()));
                this.checkRecord(server);
                this.flush();
                this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("CheckEnd::" + server.getId()));
            });
        }
        catch (Exception e) {
            log.error("check error", (Throwable)e);
        }
        finally {
            TraySyncCheckTask.IS_CHECKING = false;
        }
        return false;
    }

    private List<TrayLocalRecordItem> convert(List<Map<String, Object>> list, RecordBean table) {
        ArrayList<TrayLocalRecordItem> items = new ArrayList<TrayLocalRecordItem>();
        if (list != null && !list.isEmpty()) {
            String batchId = System.currentTimeMillis() + "";
            list.forEach(record -> {
                RecordBean recordBean = new RecordBean();
                ModelUtils.copyProperties((Object)table, (Object)recordBean);
                Map newRecord = this.resolveLinkColumn(record, recordBean);
                recordBean.setContent(Base64Utils.encode((String)JSONObject.toJSONString((Object)newRecord)));
                recordBean.setOpBatch(batchId);
                TrayLocalRecordItem item = new TrayLocalRecordItem();
                item.setOpBatch(batchId);
                item.setType("data");
                item.setContent(Base64Utils.encode((String)JSONObject.toJSONString((Object)recordBean)));
                item.setComment(table.getTable() + ":" + newRecord.get("id"));
                items.add(item);
            });
        }
        return items;
    }

    private Map<String, Object> resolveLinkColumn(Map<String, Object> row, RecordBean table) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        Map columns = ConfigSource.getColumns((String)table.getTable());
        for (Map.Entry entry : columns.entrySet()) {
            if (!row.containsKey(entry.getKey())) continue;
            if ("1".equals(entry.getValue()) || Objects.isNull(row.get(entry.getKey()))) {
                record.put((String)entry.getKey(), row.get(entry.getKey()));
                continue;
            }
            if ("encrypt".equals(entry.getValue())) {
                String encryptText = row.get(entry.getKey()).toString();
                if (encryptText.startsWith(EncryptEnum.ENCRYPT_AES256_PREFIX.getValue())) {
                    encryptText = EncryptEnum.ENCRYPT_AES256_PREFIX.getValue() + FoldexUtil.decryptByRandomSey((String)encryptText);
                }
                record.put((String)entry.getKey(), encryptText);
                continue;
            }
            String linkTable = ((String)entry.getValue()).split(":")[0];
            String val = JdbcUtils.queryUniqueColumn((String)linkTable, (String)row.get(entry.getKey()).toString());
            record.put((String)entry.getKey(), val);
        }
        return record;
    }

    private String recoverLinkColumn(RecordBean record) {
        JSONObject row = JSONObject.parseObject((String)Base64Utils.decode((String)record.getContent()));
        String ret = "1";
        Map linkColumns = ConfigSource.getLinkColumns((String)record.getTable());
        for (Map.Entry entry : linkColumns.entrySet()) {
            String colValue = row.getString((String)entry.getKey());
            if (StringUtils.isBlank((CharSequence)colValue)) continue;
            if ("encrypt".equals(entry.getValue())) {
                if (!colValue.startsWith(EncryptEnum.ENCRYPT_AES256_PREFIX.getValue())) continue;
                colValue = colValue.substring(EncryptEnum.ENCRYPT_AES256_PREFIX.getValue().length());
                row.put((String)entry.getKey(), (Object)FoldexUtil.encryptByRandomSey((String)colValue));
                continue;
            }
            String table = ((String)entry.getValue()).split(":")[0];
            RecordBean linkRecord = ConfigSource.getTableByName((String)table);
            if (linkRecord == null) continue;
            JSONObject params = new JSONObject();
            String[] columns = linkRecord.getUniqueColumn().split(",");
            String[] vals = colValue.split(",");
            for (int i = 0; i < columns.length; ++i) {
                params.put(columns[i], (Object)vals[i]);
            }
            linkRecord.setContent(Base64Utils.encode((String)params.toJSONString()));
            Map linkData = JdbcUtils.findOne((RecordBean)linkRecord);
            if (linkData != null) {
                row.put((String)entry.getKey(), linkData.get("id"));
                continue;
            }
            if (((String)entry.getValue()).contains("required")) {
                return "0";
            }
            row.put((String)entry.getKey(), null);
            ret = "2";
        }
        record.setContent(Base64Utils.encode((String)row.toJSONString()));
        return ret;
    }

    private boolean resolverRecordForData(TrayRecordItem item) {
        boolean result = false;
        String ret = "1";
        if (StringUtils.isNotBlank((CharSequence)item.getContent())) {
            RecordBean record = (RecordBean)JSONObject.parseObject((String)Base64Utils.decode((String)item.getContent()), RecordBean.class);
            if (StringUtils.isBlank((CharSequence)record.getContent())) {
                this.trayRecordService.delete(item.getId());
                return false;
            }
            RecordBean originRecord = new RecordBean();
            ModelUtils.copyProperties((Object)record, (Object)originRecord);
            ret = this.recoverLinkColumn(record);
            if ("0".equals(ret)) {
                return false;
            }
            Map localRecord = JdbcUtils.findOne((RecordBean)record);
            if (localRecord == null) {
                JdbcUtils.add((RecordBean)record);
            } else if (this.isUpdateItem(localRecord, record, item)) {
                JdbcUtils.update((RecordBean)record, (String)localRecord.get("id").toString());
            }
            if ("2".equals(ret)) {
                JSONObject json = JSONObject.parseObject((String)Base64Utils.decode((String)originRecord.getContent()));
                json.put("update_time", (Object)System.currentTimeMillis());
                originRecord.setContent(Base64Utils.encode((String)json.toJSONString()));
                item.setContent(Base64Utils.encode((String)JSONObject.toJSONString((Object)originRecord)));
                CommonUtils.catchFunction(arg0 -> this.trayRecordService.save(item), arg1 -> this.saveLocalTemp((Object)item, "remote"));
            }
        }
        if ("1".equals(ret)) {
            CommonUtils.catchFunction(args -> this.trayRecordService.delete(item.getId()));
        } else {
            result = true;
        }
        return result;
    }

    private boolean resolverRecordForImage(TrayRecordItem item, String root) {
        if ("img".equals(item.getType()) && StringUtils.isNotBlank((CharSequence)item.getContent())) {
            ImageBean image = (ImageBean)JSONObject.parseObject((String)Base64Utils.decode((String)item.getContent()), ImageBean.class);
            String imagePath = FileUtils.path((String[])new String[]{root, image.getPath()});
            File imageFile = new File(imagePath);
            FileUtils.make((String)imageFile.getParentFile().getPath());
            if (!imageFile.exists() || imageFile.lastModified() < image.getUpdateTime()) {
                if (imageFile.exists()) {
                    imageFile.delete();
                }
                FileUtils.saveFile((String)imageFile.getParentFile().getPath(), (String)imageFile.getName(), (String)image.getContent(), (boolean)false);
                FileEncryptUtil.encryptFileByPath((String)imagePath);
                FileUtils.setUpdateTime((String)imagePath, (long)image.getUpdateTime());
            }
            CommonUtils.catchFunction(args -> this.trayRecordService.delete(item.getId()));
        }
        return false;
    }

    public boolean resolverRecord() {
        boolean result = false;
        this.resolveLocalTemp("remote");
        List items = this.trayRecordService.list(new TrayRecordItem());
        if (Objects.isNull(items) || items.isEmpty()) {
            return false;
        }
        result = true;
        String root = FileUtils.getRootPath(null);
        String currentServer = "";
        for (TrayRecordItem item : items) {
            try {
                if (!StringUtils.equals((CharSequence)currentServer, (CharSequence)item.getHost())) {
                    this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("Resolver::" + item.getHost()));
                    currentServer = item.getHost();
                }
                if ("data".equals(item.getType())) {
                    if (!this.resolverRecordForData(item)) continue;
                    result = true;
                    continue;
                }
                if ("img".equals(item.getType())) {
                    if (!this.resolverRecordForImage(item, root)) continue;
                    result = true;
                    continue;
                }
                CommonUtils.catchFunction(args -> this.trayRecordService.delete(item.getId()));
            }
            catch (Exception e) {
                log.error("Sync Resolve Error" + JSONObject.toJSONString((Object)item), (Throwable)e);
            }
        }
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)"ResolverSuccess::all");
        this.flush();
        return result;
    }

    private boolean isUpdateItem(Map<String, Object> localRecord, RecordBean record, TrayRecordItem item) {
        Object localUpdateTime = localRecord.get("update_time");
        if (Objects.nonNull(localUpdateTime) && StringUtils.isNotBlank((CharSequence)record.getContent())) {
            long localTime = CommonUtils.getDateTime((Object)localUpdateTime);
            JSONObject row = JSONObject.parseObject((String)Base64Utils.decode((String)record.getContent()));
            Object remoteUpdateTime = row.get((Object)"update_time");
            if (Objects.nonNull(remoteUpdateTime)) {
                long remoteTime = CommonUtils.getDateTime((Object)remoteUpdateTime);
                if (item.getDifTime() != null) {
                    remoteTime += item.getDifTime().longValue();
                }
                return remoteTime > localTime;
            }
        }
        return false;
    }

    public boolean receiveRecord(List<TrayRecordItem> items) {
        String host = null;
        for (TrayRecordItem item : items) {
            item.setId(null);
            if (Objects.nonNull(item.getDifTime())) {
                item.setDifTime(Long.valueOf(System.currentTimeMillis() - item.getDifTime()));
            } else {
                item.setDifTime(Long.valueOf(0L));
            }
            host = item.getHost();
        }
        if (!this.trayServerService.isStop(host)) {
            TraySyncResolverTask.resolving = true;
            this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("Receive::" + host));
            CommonUtils.catchFunction(arg0 -> this.trayRecordService.saveAll(items), arg1 -> this.saveLocalTemp((Object)items, "remote"));
            this.simpMessagingTemplate.convertAndSend((Object)"/topic/traySync/getSyncStatus", (Object)("ReceiveSuccess::" + host));
        }
        return false;
    }
}

