/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.service.impl;

import com.zkteco.tray.config.ConfigSource;
import com.zkteco.tray.dao.TrayLocalRecordDao;
import com.zkteco.tray.dao.TrayRecordDao;
import com.zkteco.tray.dao.TrayServerDao;
import com.zkteco.tray.model.TrayServer;
import com.zkteco.tray.service.TrayServerService;
import com.zkteco.tray.task.TraySenderTask;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.ModelUtils;
import com.zkteco.tray.utils.SQLUtil;
import com.zkteco.tray.vo.BaseItem;
import com.zkteco.tray.vo.TrayServerItem;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrayServerServiceImpl
implements TrayServerService {
    private static final Logger log = LoggerFactory.getLogger(TrayServerServiceImpl.class);
    @Autowired
    private TrayServerDao dao;
    @Autowired
    private TrayRecordDao trayRecordDao;
    @Autowired
    private TrayLocalRecordDao trayLocalRecordDao;

    public TrayServerItem save(TrayServerItem item) {
        TrayServer server = null;
        if (StringUtils.isNotBlank((CharSequence)item.getId())) {
            server = (TrayServer)this.dao.findOne((Serializable)((Object)item.getId()));
            if (!StringUtils.equals((CharSequence)server.getHost(), (CharSequence)item.getHost()) && !server.getLocal().booleanValue()) {
                this.removeRecordByHost(server.getHost());
                server.setSyncTime(null);
            }
        } else {
            server = new TrayServer();
        }
        ModelUtils.copyPropertiesIgnoreNull((Object)item, (Object)server);
        if (Objects.isNull(server.getLocal())) {
            server.setLocal(Boolean.valueOf(false));
        }
        if (server.getLocal().booleanValue()) {
            item.setLocal(Boolean.valueOf(true));
        }
        this.dao.save((Object)server);
        ConfigSource.signServer((String)server.getHost(), (boolean)true);
        return item;
    }

    private void removeRecordByHost(String host) {
        TraySenderTask.remove((String)host);
        ConfigSource.signServer((String)host, (boolean)false);
        List list = this.trayLocalRecordDao.findByRemoteHost(host);
        if (list != null && list.size() > 0) {
            this.trayLocalRecordDao.deleteAll((Iterable)list);
        }
    }

    public boolean delete(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            try {
                Arrays.stream(ids.split(",")).forEach(id -> {
                    String host = ((TrayServer)this.dao.findById((Serializable)((Object)id)).get()).getHost();
                    this.removeRecordByHost(host);
                    this.dao.deleteById((Serializable)((Object)id));
                });
            }
            catch (Exception e) {
                log.error("tray server delete error", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public List<TrayServerItem> list(TrayServerItem condition) {
        return this.dao.getItemsBySql(condition.getClass(), SQLUtil.getSqlByItem((BaseItem)condition));
    }

    public TrayServerItem getLocalServer() {
        TrayServerItem condition = new TrayServerItem();
        condition.setLocal(Boolean.valueOf(true));
        List items = this.list(condition);
        if (items != null && items.size() > 0) {
            return (TrayServerItem)items.get(0);
        }
        return new TrayServerItem();
    }

    public TrayServerItem getItemById(String id) {
        List items = this.list(new TrayServerItem(id));
        return items == null || items.isEmpty() ? null : (TrayServerItem)items.get(0);
    }

    public TrayServerItem getItemByHost(String host) {
        if (StringUtils.isNotBlank((CharSequence)host)) {
            TrayServer server = this.dao.findByHost(host);
            TrayServerItem item = new TrayServerItem();
            ModelUtils.copyPropertiesIgnoreNull((Object)server, (Object)item);
            return item;
        }
        return null;
    }

    public boolean isStop(String host) {
        TrayServer server;
        if (StringUtils.isNotBlank((CharSequence)host) && (server = this.dao.findByHost(host)) != null) {
            return "stop".equals(server.getStatus());
        }
        return false;
    }

    public List<TrayServerItem> getServerExceptLocal() {
        TrayServerItem condition = new TrayServerItem();
        condition.setLocal(Boolean.valueOf(false));
        List items = this.list(condition);
        return items;
    }

    public void updateStatus(String id, String status, String message) {
        TrayServer server;
        TrayServer trayServer = server = id.startsWith("http") ? this.dao.findByHost(id) : (TrayServer)this.dao.findOne((Serializable)((Object)id));
        if (Objects.nonNull(server)) {
            server.setStatus(status);
            server.setMessage(message);
            CommonUtils.catchFunction(args -> this.dao.save((Object)server));
        }
    }

    public void updateSyncTime(String id, Date time) {
        try {
            TrayServer server;
            if (Objects.isNull(time)) {
                time = new Date();
            }
            if (Objects.nonNull(server = (TrayServer)this.dao.findOne((Serializable)((Object)id)))) {
                server.setSyncTime(time);
                CommonUtils.catchFunction(arg0 -> this.dao.save((Object)server));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

