/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.service.impl;

import com.zkteco.tray.dao.TrayRecordDao;
import com.zkteco.tray.model.TrayRecord;
import com.zkteco.tray.service.TrayRecordService;
import com.zkteco.tray.utils.ModelUtils;
import com.zkteco.tray.utils.SQLUtil;
import com.zkteco.tray.vo.BaseItem;
import com.zkteco.tray.vo.TrayRecordItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrayRecordServiceImpl
implements TrayRecordService {
    private static final Logger log = LoggerFactory.getLogger(TrayRecordServiceImpl.class);
    @Autowired
    private TrayRecordDao trayRecordDao;

    public TrayRecordItem save(TrayRecordItem item) {
        TrayRecord record = null;
        if (StringUtils.isNotBlank((CharSequence)item.getId())) {
            record = (TrayRecord)this.trayRecordDao.getOne((Object)item.getId());
        }
        if (Objects.isNull(record)) {
            record = new TrayRecord();
        }
        ModelUtils.copyPropertiesIgnoreNull((Object)item, record);
        this.trayRecordDao.save((Object)record);
        return item;
    }

    public boolean delete(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            try {
                Arrays.stream(ids.split(",")).forEach(id -> this.trayRecordDao.deleteById((Serializable)((Object)id)));
            }
            catch (Exception e) {
                log.error("tray record delete error", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public List<TrayRecordItem> list(TrayRecordItem condition) {
        return this.trayRecordDao.getItemsBySql(condition.getClass(), SQLUtil.getSqlByItem((BaseItem)condition));
    }

    public TrayRecordItem getItemById(String id) {
        List items = this.list(new TrayRecordItem(id));
        return items == null || items.isEmpty() ? null : (TrayRecordItem)items.get(0);
    }

    public List<TrayRecordItem> saveAll(List<TrayRecordItem> items) {
        ArrayList<TrayRecord> records = new ArrayList<TrayRecord>();
        for (TrayRecordItem item : items) {
            TrayRecord record = null;
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                record = (TrayRecord)this.trayRecordDao.getOne((Object)item.getId());
            }
            if (Objects.isNull(record)) {
                record = new TrayRecord();
            }
            ModelUtils.copyPropertiesIgnoreNull((Object)item, record);
            records.add(record);
        }
        this.trayRecordDao.saveAll(records);
        records = null;
        System.gc();
        return items;
    }
}

