/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.service.impl;

import com.zkteco.tray.dao.TrayParamDao;
import com.zkteco.tray.model.TrayParam;
import com.zkteco.tray.service.TrayParamService;
import com.zkteco.tray.utils.ModelUtils;
import com.zkteco.tray.utils.SQLUtil;
import com.zkteco.tray.vo.BaseItem;
import com.zkteco.tray.vo.TrayParamItem;
import com.zkteco.tray.vo.TraySyncParamItem;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrayParamServiceImpl
implements TrayParamService {
    private static final Logger log = LoggerFactory.getLogger(TrayParamServiceImpl.class);
    @Autowired
    private TrayParamDao trayParamDao;

    public TrayParamItem saveItem(TrayParamItem item) {
        TrayParam param = null;
        if (StringUtils.isNotBlank((CharSequence)item.getParamName())) {
            param = this.trayParamDao.findByParamName(item.getParamName());
        }
        if (Objects.isNull(param)) {
            param = new TrayParam();
        }
        ModelUtils.copyPropertiesIgnoreNull((Object)item, (Object)param);
        this.trayParamDao.save((Object)param);
        return item;
    }

    public boolean delete(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            try {
                Arrays.stream(ids.split(",")).forEach(id -> this.trayParamDao.deleteById((Serializable)((Object)id)));
            }
            catch (Exception e) {
                log.error("tray param delete error", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public List<TrayParamItem> list(TrayParamItem condition) {
        return this.trayParamDao.getItemsBySql(condition.getClass(), SQLUtil.getSqlByItem((BaseItem)condition));
    }

    public TrayParamItem getItemById(String id) {
        List items = this.list(new TrayParamItem(id));
        return items == null || items.isEmpty() ? null : (TrayParamItem)items.get(0);
    }

    public TrayParamItem getItemByParamName(String paramName) {
        TrayParamItem item = null;
        TrayParam param = this.trayParamDao.findByParamName(paramName);
        if (Objects.nonNull(param)) {
            item = new TrayParamItem();
            ModelUtils.copyProperties((Object)param, (Object)item);
        }
        return item;
    }

    public String getValueByName(String paramName, String def) {
        try {
            TrayParam param = this.trayParamDao.findByParamName(paramName);
            if (Objects.nonNull(param) && StringUtils.isNotBlank((CharSequence)param.getParamValue())) {
                return param.getParamValue();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return def;
    }

    public boolean updateSyncTime() {
        try {
            TrayParamItem param = new TrayParamItem();
            param.setParamName("tray.sync.lastTime");
            param.setParamValue("" + System.currentTimeMillis());
            this.saveItem(param);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return false;
    }

    public TraySyncParamItem getSyncParam() {
        TraySyncParamItem item = new TraySyncParamItem();
        String rt = this.getValueByName("tray.sync.time", "1");
        String ct = this.getValueByName("tray.sync.check.time", "1");
        item.setCheckTime(ct);
        item.setResolveTime(rt);
        return item;
    }

    public TraySyncParamItem saveSyncParam(TraySyncParamItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getCheckTime())) {
            this.saveItem(new TrayParamItem("tray.sync.check.time", item.getCheckTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getResolveTime())) {
            this.saveItem(new TrayParamItem("tray.sync.time", item.getResolveTime()));
        }
        return item;
    }
}

