/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.service.impl;

import com.zkteco.tray.dao.TrayLocalRecordDao;
import com.zkteco.tray.model.TrayLocalRecord;
import com.zkteco.tray.service.TrayLocalRecordService;
import com.zkteco.tray.utils.ModelUtils;
import com.zkteco.tray.utils.SQLUtil;
import com.zkteco.tray.vo.BaseItem;
import com.zkteco.tray.vo.TrayLocalRecordItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrayLocalRecordServiceImpl
implements TrayLocalRecordService {
    private static final Logger log = LoggerFactory.getLogger(TrayLocalRecordServiceImpl.class);
    @Autowired
    private TrayLocalRecordDao trayLocalRecordDao;

    public TrayLocalRecordItem save(TrayLocalRecordItem item) {
        TrayLocalRecord record = null;
        if (StringUtils.isNotBlank((CharSequence)item.getId())) {
            record = (TrayLocalRecord)this.trayLocalRecordDao.getOne((Object)item.getId());
        }
        if (Objects.isNull(record)) {
            record = new TrayLocalRecord();
        }
        ModelUtils.copyPropertiesIgnoreNull((Object)item, record);
        this.trayLocalRecordDao.save((Object)record);
        return item;
    }

    public boolean delete(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            try {
                Arrays.stream(ids.split(",")).forEach(id -> this.trayLocalRecordDao.deleteById((Serializable)((Object)id)));
            }
            catch (Exception e) {
                log.error("tray record delete error", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public List<TrayLocalRecordItem> list(TrayLocalRecordItem condition) {
        return this.trayLocalRecordDao.getItemsBySql(condition.getClass(), SQLUtil.getSqlByItem((BaseItem)condition));
    }

    public TrayLocalRecordItem getItemById(String id) {
        List items = this.list(new TrayLocalRecordItem(id));
        return items == null || items.isEmpty() ? null : (TrayLocalRecordItem)items.get(0);
    }

    public List<TrayLocalRecordItem> saveAll(List<TrayLocalRecordItem> items) {
        ArrayList<TrayLocalRecord> records = new ArrayList<TrayLocalRecord>();
        for (TrayLocalRecordItem item : items) {
            TrayLocalRecord record = null;
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                record = (TrayLocalRecord)this.trayLocalRecordDao.getOne((Object)item.getId());
            }
            if (Objects.isNull(record)) {
                record = new TrayLocalRecord();
            }
            ModelUtils.copyPropertiesIgnoreNull((Object)item, record);
            records.add(record);
        }
        this.trayLocalRecordDao.saveAll(records);
        records = null;
        System.gc();
        return items;
    }

    public void updateTime(String id) {
        TrayLocalRecord record = (TrayLocalRecord)this.trayLocalRecordDao.findOne((Serializable)((Object)id));
        if (record != null) {
            record.setCreateTime(new Date());
            record.setStatus("1");
            this.trayLocalRecordDao.save((Object)record);
        }
    }
}

