/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.service.impl;

import com.zkteco.tray.service.TrayDatabaseSettingsService;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.DBUtils;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.FileUtils;
import com.zkteco.tray.utils.ModelUtils;
import com.zkteco.tray.vo.TrayParamsItem;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.io.File;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrayDatabaseSettingsServiceImpl
implements TrayDatabaseSettingsService {
    private static final Logger log = LoggerFactory.getLogger(TrayDatabaseSettingsServiceImpl.class);

    public TrayParamsItem getItem() {
        return ExecUtils.getNParams();
    }

    public TrayParamsItem saveItem(TrayParamsItem item) {
        TrayParamsItem params = this.getItem();
        ModelUtils.copyPropertiesIgnoreNull((Object)item, (Object)params);
        this.resolveParams(params);
        if (CommonUtils.isWindow()) {
            ExecUtils.rebootService((TrayParamsItem)params);
        } else {
            String root = FileUtils.getRootPath(null);
            if (StringUtils.isNotBlank((CharSequence)root)) {
                String file = FileUtils.path((String[])new String[]{root, "Config", "app.params"});
                String koratPath = FileUtils.findRootByFiles((File)new File(root), (String[])new String[]{"korat"});
                if (FileUtils.exists((String)file)) {
                    try {
                        FileUtils.write((String)file, (String)ExecUtils.encrypt((TrayParamsItem)params), (boolean)false);
                        if (StringUtils.isNotBlank((CharSequence)koratPath)) {
                            FileUtils.write((String)FileUtils.path((String[])new String[]{koratPath, "app.params"}), (String)ExecUtils.encrypt((TrayParamsItem)params), (boolean)false);
                        }
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            }
        }
        return params;
    }

    public void reboot() {
        TrayParamsItem params = this.getItem();
        if (CommonUtils.isLinux()) {
            String root = System.getProperty("user.dir");
            String restartSh = FileUtils.path((String[])new String[]{root, "restart.sh"});
            if (FileUtils.exists((String)restartSh)) {
                ExecUtils.exec((String)("bash " + restartSh));
            }
        }
    }

    private void updateDBPassword(TrayParamsItem params) {
        if ("postgre".equals(params.getDbType())) {
            this.updateDBPassword4PostgreSQL(params);
        } else if ("oracle".equals(params.getDbType())) {
            this.updateDBPassword4Oracle(params);
        } else if ("mssql".equals(params.getDbType())) {
            this.updateDBPassword4SQLServer(params);
        } else if ("dm".equals(params.getDbType())) {
            this.updateDBPassword4DM(params);
        }
    }

    private void updateDBPassword4DM(TrayParamsItem params) {
        Connection con = DBUtils.getConnection((TrayParamsItem)params);
        if (con != null) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("alter user ");
                sql.append(params.getDbUser());
                sql.append(" identified by '");
                sql.append(ExecUtils.getDecryptPwd((TrayParamsItem)params, (String)params.getDbPwd()));
                sql.append("';");
                con.createStatement().executeUpdate(sql.toString());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private void updateDBPassword4Oracle(TrayParamsItem params) {
        Connection con = DBUtils.getConnection((TrayParamsItem)params);
        if (con != null) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("alter user ");
                sql.append(params.getDbUser());
                sql.append(" identified by '");
                sql.append(ExecUtils.getDecryptPwd((TrayParamsItem)params, (String)params.getDbPwd()));
                sql.append("';");
                con.createStatement().executeUpdate(sql.toString());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private void updateDBPassword4SQLServer(TrayParamsItem params) {
        Connection con = DBUtils.getConnection((TrayParamsItem)params);
        if (con != null) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("alter login ");
                sql.append(params.getDbUser());
                sql.append(" with password '");
                sql.append(ExecUtils.getDecryptPwd((TrayParamsItem)params, (String)params.getDbPwd()));
                sql.append("';");
                con.createStatement().executeUpdate(sql.toString());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private void updateDBPassword4PostgreSQL(TrayParamsItem params) {
        Connection con = DBUtils.getConnection((TrayParamsItem)params);
        if (con != null) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("alter role ");
                sql.append(params.getDbUser());
                sql.append(" with password '");
                sql.append(ExecUtils.getDecryptPwd((TrayParamsItem)params, (String)params.getDbPwd()));
                sql.append("';");
                con.createStatement().executeUpdate(sql.toString());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private TrayParamsItem resolveParams(TrayParamsItem item) {
        if ("1".equals(item.getPwdEncrypt()) && !item.getDbPwd().endsWith("==")) {
            item.setDbPwd(FoldexUtil.encryptInstallDate((String)item.getDbPwd()));
        }
        return item;
    }
}

