/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.security;

import com.zkteco.tray.utils.SecurityUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JwtAuthenticationFilter
extends BasicAuthenticationFilter {
    private static List<String> authData = new ArrayList();

    private boolean isAuth(String url) {
        for (String s : authData) {
            if (!Pattern.matches(s, url)) continue;
            return true;
        }
        return false;
    }

    @Autowired
    public JwtAuthenticationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute("uuid", (Object)UUID.randomUUID());
        if (this.isAuth(request.getRequestURI())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            SecurityUtils.checkAuthentication((HttpServletRequest)request);
            if (Objects.isNull(SecurityContextHolder.getContext().getAuthentication())) {
                response.sendRedirect("/");
                return;
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    static {
        authData.add("/");
        authData.add("/.*.html");
        authData.add("/login.*");
        authData.add("/logoutUser");
        authData.add("/validAdmin");
        authData.add("/validUser");
        authData.add("/i18nLoader");
        authData.add("/css/.*");
        authData.add("/html/.*");
        authData.add("/imgs/.*");
        authData.add("/js/.*");
        authData.add("/ws/.*");
        authData.add("/libs/.*");
        authData.add("/favicon.ico");
        authData.add("/receive");
        authData.add("/test");
    }
}

