/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.dao;

import com.zkteco.tray.bean.Pager;
import com.zkteco.tray.bean.SQLBean;
import com.zkteco.tray.config.AddScalar;
import com.zkteco.tray.dao.BaseDao;
import com.zkteco.tray.dao.SqlParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.SQLQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class BaseDaoImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseDao<T, ID> {
    private final EntityManager entityManager;

    public List<T> findByIdList(Collection<ID> ids) {
        Query query = this.entityManager.createQuery("FROM " + this.getDomainClass().getName() + " t WHERE t.id IN (:ids)");
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    public List<T> findByIdList(List<ID> ids) {
        Query query = this.entityManager.createQuery("FROM " + this.getDomainClass().getName() + " t WHERE t.id IN (:ids)");
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    public BaseDaoImpl(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this.entityManager = entityManager;
    }

    public List getItemsBySql(Class target, String sql) {
        return this.getItemsDataBySql(target, sql, null, true);
    }

    public List getItemsDataBySql(Class target, String sql, Pager pager, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createSqlQuery(sql);
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, (Class)target);
            sqlQuery.setResultTransformer(Transformers.aliasToBean((Class)target));
        }
        if (pager != null) {
            sqlQuery.setFirstResult(pager.getOffset());
            sqlQuery.setMaxResults(pager.getSize());
        }
        return sqlQuery.list();
    }

    public List getItemsDataBySql(Class target, String sql, int beginIndex, int endIndex, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createSqlQuery(sql);
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, (Class)target);
            sqlQuery.setResultTransformer(Transformers.aliasToBean((Class)target));
        }
        sqlQuery.setFirstResult(beginIndex);
        sqlQuery.setMaxResults(endIndex - beginIndex + 1);
        return sqlQuery.list();
    }

    private NativeQuery createSqlQuery(String sql) {
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        return (NativeQuery)nativeQuery.unwrap(NativeQueryImpl.class);
    }

    public List createSqlQueryPage(String sql, int start, int size) {
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        nativeQuery.setFirstResult(start);
        nativeQuery.setMaxResults(size);
        return nativeQuery.getResultList();
    }

    private Query createHqlQuery(String hql) {
        Query query = this.entityManager.createQuery(hql);
        return query;
    }

    public List<Object[]> getArrayData(String sql) {
        return this.createSqlQuery(sql).list();
    }

    public Pager getItemsBySql(Class target, String sql, int page, int size) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountBySql(sql));
        pager.setData(this.getItemsDataBySql(target, sql, pager, true));
        return pager;
    }

    public Pager getArrayItemsBySql(Class target, String sql, int page, int size) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountBySql(sql));
        pager.setData(this.getItemsDataBySql(target, sql, pager, false));
        return pager;
    }

    public Optional<T> findById(ID id) {
        Object t = this.entityManager.find(this.getDomainClass(), id);
        return Optional.ofNullable(t);
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        Optional optional = this.findById(id);
        if (optional.isPresent()) {
            this.delete(optional.get());
        } else {
            new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.getDomainClass(), id), 1);
        }
    }

    public int getCountBySql(String sql) {
        String countSql = new SqlParser().getSmartCountSql(sql);
        try {
            String countNum = this.createSqlQuery(countSql).uniqueResult().toString();
            int count = Integer.valueOf(countNum);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("sql can't be auto count, sql is:" + countSql, e);
        }
    }

    public void deleteAll() {
        Query query = this.entityManager.createQuery("DELETE FROM " + this.getDomainClass().getName());
        query.executeUpdate();
    }

    public void truncateAll() {
        Query query = this.entityManager.createNativeQuery("TRUNCATE TABLE " + this.getDomainClass().getAnnotation(Table.class).name());
        query.executeUpdate();
    }

    public List getItemsBySql(Class target, SQLBean sql) {
        return this.getItemsDataBySql(target, sql, null, true);
    }

    public List getItemsDataBySql(Class target, SQLBean sql, Pager pager, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createPrePareSqlQuery(sql.getSql(), sql.getList());
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, (Class)target);
            sqlQuery.setResultTransformer(Transformers.aliasToBean((Class)target));
        }
        if (pager != null) {
            sqlQuery.setFirstResult(pager.getOffset());
            sqlQuery.setMaxResults(pager.getSize());
        }
        return sqlQuery.list();
    }

    public List getItemsDataBySql(Class target, SQLBean sql, int beginIndex, int endIndex, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createPrePareSqlQuery(sql.getSql(), sql.getList());
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, (Class)target);
            sqlQuery.setResultTransformer(Transformers.aliasToBean((Class)target));
        }
        sqlQuery.setFirstResult(beginIndex);
        sqlQuery.setMaxResults(endIndex - beginIndex + 1);
        return sqlQuery.list();
    }

    public Pager getItemsBySql(Class target, SQLBean sql, int page, int size) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountByPrePareSql(sql));
        pager.setData(this.getItemsDataBySql(target, sql, pager, true));
        return pager;
    }

    public int getCountByPrePareSql(SQLBean sql) {
        String countSql = new SqlParser().getSmartCountSql(sql.getSql());
        try {
            NativeQuery prePareSqlQuery = this.createPrePareCountSqlQuery(countSql, sql);
            String countNum = prePareSqlQuery.uniqueResult().toString();
            int count = Integer.valueOf(countNum);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("sql can't be auto count, sql is:" + countSql, e);
        }
    }

    private NativeQuery createPrePareSqlQuery(String sql, List<Object> list) {
        sql = sql.replace("#", "?");
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        for (int i = 0; i < list.size(); ++i) {
            Object param = list.get(i);
            nativeQuery.setParameter(i + 1, param);
        }
        return (NativeQuery)nativeQuery.unwrap(NativeQuery.class);
    }

    private NativeQuery createPrePareCountSqlQuery(String sql, SQLBean sqlBean) {
        List list = sqlBean.getList();
        ArrayList removeList = new ArrayList();
        ArrayList countList = new ArrayList(list);
        Map valueMap = sqlBean.getValueMap();
        for (Integer index : valueMap.keySet()) {
            Object o = valueMap.get(index);
            if (!list.get(index).equals(o)) continue;
            removeList.add(o);
        }
        countList.removeAll(removeList);
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        for (int i = 0; i < countList.size(); ++i) {
            Object param = countList.get(i);
            nativeQuery.setParameter(i + 1, param);
        }
        return (NativeQuery)nativeQuery.unwrap(NativeQuery.class);
    }

    public T findOne(ID id) {
        return this.findById(id).get();
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        return this.saveAll(entities);
    }

    public void delete(Iterable<? extends T> entities) {
        this.deleteAll(entities);
    }

    @Transactional
    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        Object entity = this.findOne(id);
        if (entity == null) {
            new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.getDomainClass(), id), 1);
        }
        this.delete(entity);
    }

    public List<T> findAll(Iterable<ID> ids) {
        return this.findAllById(ids);
    }
}

