/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.controller;

import com.zkteco.tray.bean.ZKResultMsg;
import com.zkteco.tray.controller.BaseController;
import com.zkteco.tray.remote.TraySoftUpgradeRemote;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.FileUtils;
import com.zkteco.tray.utils.ZipUtils;
import com.zkteco.tray.vo.TrayUpgradeItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class TraySoftUpgradeController
extends BaseController
implements TraySoftUpgradeRemote {
    private static final Logger log = LoggerFactory.getLogger(TraySoftUpgradeController.class);

    public ModelAndView index() {
        File[] files;
        File backDir;
        String root = FileUtils.getRootPath(null);
        if (StringUtils.isNotBlank((CharSequence)root) && (backDir = new File(FileUtils.path((String[])new String[]{root, "backJar"}))).exists() && (files = backDir.listFiles()) != null && files.length > 0) {
            ArrayList<TrayUpgradeItem> items = new ArrayList<TrayUpgradeItem>();
            for (File file : files) {
                if (!file.isDirectory()) continue;
                TrayUpgradeItem item = new TrayUpgradeItem();
                String cont = FileUtils.read((String)FileUtils.path((String[])new String[]{file.getPath(), "update.txt"}));
                item.setComment(cont.split("\\[new]")[0]);
                item.setTime(file.getName());
                items.add(item);
            }
            Collections.sort(items, Comparator.comparing(TrayUpgradeItem::getTime));
            this.request.setAttribute("records", items);
        }
        return new ModelAndView("html/jarupdate/jarupdate");
    }

    private String transferToLocal(TrayUpgradeItem item) {
        String temp = FileUtils.createTemp();
        if (Objects.isNull(item.getJars())) {
            return temp;
        }
        for (MultipartFile file : item.getJars()) {
            try {
                if (StringUtils.isNotBlank((CharSequence)file.getOriginalFilename()) && file.getOriginalFilename().endsWith("zip")) {
                    String zipFile = FileUtils.path((String[])new String[]{temp, file.getOriginalFilename()});
                    file.transferTo(new File(zipFile));
                    ZipUtils.unzip((String)zipFile, (String)temp);
                    FileUtils.deleteFile((String)zipFile);
                    continue;
                }
                if (!file.getOriginalFilename().endsWith(".jar")) continue;
                file.transferTo(new File(FileUtils.path((String[])new String[]{temp, file.getOriginalFilename()})));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return temp;
    }

    private void updateFile(String src, String dist, String back) {
        File distFile = new File(dist);
        File srcFile = new File(src);
        if (distFile.exists()) {
            FileUtils.renameTo((String)dist, (String)FileUtils.path((String[])new String[]{back, distFile.getName()}));
            ExecUtils.chmod((String)back, (String)FileUtils.path((String[])new String[]{back, distFile.getName()}), (String)"775");
        } else {
            FileUtils.write((String)FileUtils.path((String[])new String[]{back, "update.txt"}), (String)(distFile.getName() + ","), (boolean)true);
        }
        FileUtils.renameTo((String)src, (String)FileUtils.path((String[])new String[]{distFile.getParentFile().getPath(), srcFile.getName()}));
        ExecUtils.chmod((String)distFile.getParentFile().getPath(), (String)FileUtils.path((String[])new String[]{distFile.getParentFile().getPath(), srcFile.getName()}), (String)"775");
    }

    private void resolveJar(String root, String temp, String backup) {
        List files = FileUtils.findFiles((String)temp, (String)"(.)*\\.jar", null);
        if (files.size() > 0) {
            File[] libs = new File(FileUtils.path((String[])new String[]{root, "service", "zkbiosecurity", "lib", "jar"})).listFiles();
            for (File jar : files) {
                File distFile;
                String dist = "zkbiosecurity-startup.jar".equals(jar.getName()) ? FileUtils.path((String[])new String[]{root, "service", "zkbiosecurity", "zkbiosecurity-startup.jar"}) : ((distFile = FileUtils.getFile((File)jar, (File[])libs)) != null ? distFile.getPath() : FileUtils.path((String[])new String[]{root, "service", "zkbiosecurity", "lib", "jar", jar.getName()}));
                this.updateFile(jar.getPath(), dist, backup);
            }
        }
    }

    public ZKResultMsg upload(TrayUpgradeItem item) {
        String root = FileUtils.getRootPath(null);
        if (StringUtils.isNotBlank((CharSequence)root)) {
            String back = FileUtils.path((String[])new String[]{root, "backJar", CommonUtils.getCurrentDate()});
            FileUtils.makeNew((String)back);
            ExecUtils.stopServer();
            FileUtils.write((String)FileUtils.path((String[])new String[]{back, "update.txt"}), (String)(item.getComment() + "\n[new]\n"), (boolean)false);
            String temp = this.transferToLocal(item);
            this.resolveJar(root, temp, back);
            FileUtils.deleteFile((String)temp);
            ExecUtils.startServer();
        }
        return new ZKResultMsg();
    }

    public ZKResultMsg rollback(String id) {
        File backDir;
        String root = FileUtils.getRootPath(null);
        if (StringUtils.isNotBlank((CharSequence)root) && (backDir = new File(FileUtils.path((String[])new String[]{root, "backJar", id}))).exists()) {
            File[] files;
            String news;
            ExecUtils.stopServer();
            String libs = FileUtils.path((String[])new String[]{root, "service", "zkbiosecurity", "lib", "jar"});
            String cont = FileUtils.read((String)FileUtils.path((String[])new String[]{backDir.getPath(), "update.txt"}));
            if (StringUtils.isNotBlank((CharSequence)cont) && StringUtils.isNotBlank((CharSequence)(news = cont.split("\\[new]")[1]))) {
                String[] jars = news.split(",");
                for (String jar : jars) {
                    if (!StringUtils.isNotBlank((CharSequence)jar)) continue;
                    FileUtils.deleteFile((String)FileUtils.path((String[])new String[]{libs, jar}));
                }
            }
            if ((files = backDir.listFiles()) != null && files.length > 0) {
                File[] libFiles = new File(libs).listFiles();
                for (File file : files) {
                    String dist;
                    if (!file.getName().matches("(.)*\\.jar")) continue;
                    if ("zkbiosecurity-startup.jar".equals(file.getName())) {
                        dist = FileUtils.path((String[])new String[]{root, "service", "zkbiosecurity", "zkbiosecurity-startup.jar"});
                    } else {
                        File distFile = FileUtils.getFile((File)file, (File[])libFiles);
                        if (distFile != null) {
                            distFile.delete();
                        }
                        dist = FileUtils.path((String[])new String[]{libs, file.getName()});
                    }
                    FileUtils.renameTo((String)file.getPath(), (String)dist);
                }
            }
            FileUtils.deleteFile((String)backDir.getPath());
            ExecUtils.startServer();
        }
        return ZKResultMsg.succseeMsg();
    }
}

