/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.tray.bean.ZKResultMsg;
import com.zkteco.tray.i18n.IFrontI18nKeys;
import com.zkteco.tray.remote.TrayPortalRemote;
import com.zkteco.tray.service.TraySyncService;
import com.zkteco.tray.utils.Base64Utils;
import com.zkteco.tray.utils.I18nUtil;
import com.zkteco.tray.vo.TrayRecordItem;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TrayPortalController
implements TrayPortalRemote {
    @Autowired
    private IFrontI18nKeys[] i18nKeys;
    @Autowired
    private TraySyncService traySyncService;

    public String i18nLoader() {
        StringBuffer content = new StringBuffer();
        if (this.i18nKeys != null && this.i18nKeys.length > 0) {
            content.append("if(localStorage){");
            TreeSet items = new TreeSet();
            for (IFrontI18nKeys key : this.i18nKeys) {
                items.addAll(key.keys());
            }
            String value = null;
            for (String item : items) {
                if (item.equals(value = I18nUtil.i18nCode((String)item, (Object[])new Object[0]))) continue;
                content.append("localStorage.setItem(\"");
                content.append(item);
                content.append("\",\"");
                content.append(value.replaceAll("\"", "\\\\\""));
                content.append("\");");
            }
            content.append("}");
        }
        return content.toString();
    }

    public ZKResultMsg receive(String cont) {
        if (StringUtils.isNotBlank((CharSequence)cont)) {
            List items = JSONObject.parseArray((String)Base64Utils.decode((String)cont), TrayRecordItem.class);
            this.traySyncService.receiveRecord(items);
            return ZKResultMsg.succseeMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg test() {
        return ZKResultMsg.succseeMsg();
    }
}

