/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.zkteco.tray.bean.ZKResultMsg;
import com.zkteco.tray.config.ConfigSource;
import com.zkteco.tray.controller.BaseController;
import com.zkteco.tray.remote.TrayDbSyncRemote;
import com.zkteco.tray.service.TrayParamService;
import com.zkteco.tray.service.TrayServerService;
import com.zkteco.tray.service.TraySyncService;
import com.zkteco.tray.utils.HttpUtils;
import com.zkteco.tray.utils.I18nUtil;
import com.zkteco.tray.vo.TrayServerItem;
import com.zkteco.tray.vo.TraySyncParamItem;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class TrayDbSyncController
extends BaseController
implements TrayDbSyncRemote {
    @Autowired
    private TrayServerService service;
    @Autowired
    private TraySyncService traySyncService;
    @Autowired
    private TrayParamService trayParamService;

    public ModelAndView index() {
        TrayServerItem item = ConfigSource.getLocalServer();
        if (item == null) {
            item = this.service.getLocalServer();
            ConfigSource.setLocalServer((TrayServerItem)item);
        }
        this.request.setAttribute("local", (Object)item);
        return new ModelAndView("/html/dbsync/dbsync");
    }

    public ModelAndView edit(TrayServerItem item) {
        if (Objects.nonNull(item.getLocal()) && item.getLocal().booleanValue()) {
            item = this.service.getLocalServer();
        } else if (StringUtils.isNotBlank((CharSequence)item.getId())) {
            item = this.service.getItemById(item.getId());
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("/html/dbsync/editServer");
    }

    public ModelAndView settings() {
        TraySyncParamItem item = this.trayParamService.getSyncParam();
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("/html/dbsync/settings");
    }

    public ZKResultMsg editSettings(TraySyncParamItem item) {
        this.trayParamService.saveSyncParam(item);
        return ZKResultMsg.succseeMsg();
    }

    private boolean validServer(TrayServerItem cond, TrayServerItem item) {
        TrayServerItem local = ConfigSource.getLocalServer();
        if (local != null && local.getHost().equals(cond.getHost())) {
            return false;
        }
        List s1 = this.service.list(cond);
        return s1 == null || s1.isEmpty() || ((TrayServerItem)s1.get(0)).getId().equals(item.getId());
    }

    public ZKResultMsg save(TrayServerItem item) {
        if (StringUtils.isBlank((CharSequence)item.getName())) {
            return ZKResultMsg.failMsg((String)String.format(I18nUtil.i18nCode((String)"common_error_empty", (Object[])new Object[0]), I18nUtil.i18nCode((String)"sync_server_name", (Object[])new Object[0])));
        }
        if (StringUtils.isBlank((CharSequence)item.getHost())) {
            return ZKResultMsg.failMsg((String)String.format(I18nUtil.i18nCode((String)"common_error_empty", (Object[])new Object[0]), I18nUtil.i18nCode((String)"system_dbhost", (Object[])new Object[0])));
        }
        TrayServerItem cond = new TrayServerItem();
        cond.setName(item.getName());
        if (!this.validServer(cond, item)) {
            return ZKResultMsg.failMsg((String)String.format(I18nUtil.i18nCode((String)"common_error_repeat", (Object[])new Object[0]), I18nUtil.i18nCode((String)"sync_server_name", (Object[])new Object[0])));
        }
        cond = new TrayServerItem();
        cond.setHost(item.getHost());
        if (!this.validServer(cond, item)) {
            return ZKResultMsg.failMsg((String)String.format(I18nUtil.i18nCode((String)"common_error_repeat", (Object[])new Object[0]), I18nUtil.i18nCode((String)"system_dbhost", (Object[])new Object[0])));
        }
        this.service.save(item);
        if (Objects.nonNull(item.getLocal()) && item.getLocal().booleanValue()) {
            ConfigSource.setLocalServer((TrayServerItem)item);
        }
        CompletableFuture.supplyAsync(() -> {
            this.traySyncService.check();
            return "success";
        });
        return ZKResultMsg.succseeMsg();
    }

    public ZKResultMsg del(String ids) {
        this.service.delete(ids);
        return ZKResultMsg.succseeMsg();
    }

    public ZKResultMsg list(TrayServerItem item) {
        if (Objects.isNull(item.getLocal())) {
            item.setLocal(Boolean.valueOf(false));
        }
        List items = this.service.list(item);
        return ZKResultMsg.succseeMsg().setData((Object)items);
    }

    public ZKResultMsg checkSync() {
        CompletableFuture.supplyAsync(() -> {
            this.traySyncService.check();
            return "success";
        });
        return ZKResultMsg.succseeMsg();
    }

    public ZKResultMsg testConnect(String id) {
        TrayServerItem server;
        if (StringUtils.isNotBlank((CharSequence)id) && (server = this.service.getItemById(id)) != null) {
            try {
                JSONObject res;
                String resp = HttpUtils.get((String)(server.getHost() + "/test"));
                if (JSONValidator.from((String)resp).validate() && StringUtils.equalsIgnoreCase((CharSequence)(res = JSONObject.parseObject((String)resp)).getString("ret"), (CharSequence)ZKResultMsg.RET_OK)) {
                    return ZKResultMsg.succseeMsg();
                }
            }
            catch (Exception e) {
                return ZKResultMsg.failMsg();
            }
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg stop(String id) {
        TrayServerItem server;
        if (StringUtils.isNotBlank((CharSequence)id) && (server = this.service.getItemById(id)) != null) {
            if ("stop".equals(server.getStatus())) {
                this.service.updateStatus(id, "wait", "");
            } else {
                this.service.updateStatus(id, "stop", "");
            }
            return ZKResultMsg.succseeMsg();
        }
        return ZKResultMsg.failMsg();
    }
}

