/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.controller;

import com.zkteco.tray.bean.ZKResultMsg;
import com.zkteco.tray.controller.BaseController;
import com.zkteco.tray.remote.TrayCertRemote;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.FileUtils;
import com.zkteco.tray.vo.TrayCertItem;
import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class TrayCertController
extends BaseController
implements TrayCertRemote {
    private static final Logger log = LoggerFactory.getLogger(TrayCertController.class);

    public ModelAndView index() {
        return new ModelAndView("/html/cert/cert");
    }

    public ZKResultMsg edit(TrayCertItem item) {
        if (Objects.nonNull(item.getCert()) && item.getCert().getOriginalFilename().endsWith("crt")) {
            String root = FileUtils.getRootPath(null);
            String ssl = FileUtils.path((String[])new String[]{root, "service", "zkbiosecurity", "ssl"});
            String sslBack = FileUtils.path((String[])new String[]{root, "service", "zkbiosecurity", "ssl-back-" + System.currentTimeMillis()});
            try {
                String bat;
                FileUtils.copy((String)ssl, (String)sslBack);
                FileUtils.deleteFile((String)ssl, (String)".*crt.*|.*key.*|.*\\.p12");
                item.getCert().transferTo(new File(FileUtils.path((String[])new String[]{ssl, item.getCert().getOriginalFilename()})));
                if (Objects.nonNull(item.getKey())) {
                    item.getKey().transferTo(new File(FileUtils.path((String[])new String[]{ssl, item.getKey().getOriginalFilename()})));
                }
                if (!FileUtils.exists((String)(bat = FileUtils.path((String[])new String[]{ssl, "changeSSL.bat"})))) {
                    FileUtils.saveFile((String)bat, (InputStream)this.getClass().getResourceAsStream("/script/changeSSL.bat"));
                }
                ExecUtils.execBat((String)bat, (String[])new String[0]);
                return ZKResultMsg.succseeMsg();
            }
            catch (Exception e) {
                FileUtils.copy((String)FileUtils.path((String[])new String[]{sslBack, "zk.p12"}), (String)FileUtils.path((String[])new String[]{ssl, "zk.p12"}));
                log.error("", (Throwable)e);
            }
        }
        return ZKResultMsg.failMsg();
    }
}

