/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.tray.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.tray.bean.ZKResultMsg;
import com.zkteco.tray.controller.BaseController;
import com.zkteco.tray.remote.LoginRemote;
import com.zkteco.tray.security.JwtAuthenticatioToken;
import com.zkteco.tray.security.JwtUserDetails;
import com.zkteco.tray.utils.CommonUtils;
import com.zkteco.tray.utils.ExecUtils;
import com.zkteco.tray.utils.HttpUtils;
import com.zkteco.tray.utils.I18nUtil;
import com.zkteco.tray.utils.SecurityUtils;
import com.zkteco.tray.vo.TrayParamsItem;
import com.zkteco.tray.vo.TrayUserItem;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LoginController
extends BaseController
implements LoginRemote {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private UserDetailsService userDetailsService;

    public ModelAndView index() {
        return new ModelAndView("/html/login/login");
    }

    public ZKResultMsg login(TrayUserItem item) {
        String username = item.getUsername();
        String password = item.getPassword();
        if (StringUtils.isBlank((CharSequence)username)) {
            return ZKResultMsg.failMsg((String)String.format(I18nUtil.i18nCode((String)"common_error_empty", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_user", (Object[])new Object[0])));
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            return ZKResultMsg.failMsg((String)String.format(I18nUtil.i18nCode((String)"common_error_empty", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_pwd", (Object[])new Object[0])));
        }
        JwtAuthenticatioToken token = SecurityUtils.login((HttpServletRequest)this.request, (String)username, (String)password, (AuthenticationManager)this.authenticationManager);
        this.request.getSession().setAttribute(username, (Object)CommonUtils.md5((String)password));
        return new ZKResultMsg((Object)token);
    }

    public ZKResultMsg logout(TrayUserItem item) {
        SecurityUtils.logout((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        return new ZKResultMsg();
    }

    public ZKResultMsg validAdmin(String password) {
        Authentication authentication;
        if (StringUtils.isNotBlank((CharSequence)password) && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null) {
            Object obj = authentication.getPrincipal();
            String userName = "admin";
            if (obj instanceof JwtUserDetails) {
                userName = ((JwtUserDetails)obj).getUsername();
            } else if (obj instanceof String) {
                userName = obj.toString();
            }
            try {
                if (CommonUtils.md5((String)password).equals(this.request.getSession().getAttribute(userName))) {
                    return ZKResultMsg.succseeMsg();
                }
            }
            catch (Exception e) {
                log.error("valid admin error", (Throwable)e);
            }
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg validServer(String password, String server) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{password, server})) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("username", "admin");
            params.put("password", CommonUtils.md5((String)password));
            String resp = HttpUtils.post((String)(server + "/validUser"), params);
            JSONObject cont = JSONObject.parseObject((String)resp);
            if (ZKResultMsg.RET_OK.equals(cont.getString("ret"))) {
                return ZKResultMsg.succseeMsg();
            }
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg validUser(TrayUserItem item) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getPassword(), item.getUsername()})) {
            TrayParamsItem params = ExecUtils.getNParams();
            String url = Boolean.TRUE.toString().equals(params.getServerSslEnable()) ? "https" : "http";
            url = url + "://127.0.0.1:" + params.getPort();
            String resp = HttpUtils.post((String)(url = url + "/login.do?username=" + item.getUsername() + "&password=" + item.getPassword()), (String)"");
            JSONObject cont = JSONObject.parseObject((String)resp);
            if (ZKResultMsg.RET_OK.equals(cont.getString("ret"))) {
                return ZKResultMsg.succseeMsg();
            }
        }
        return ZKResultMsg.failMsg();
    }
}

